/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util.javafx;

import com.xwintop.xcore.util.javafx.JavaFxViewUtil;
import com.xwintop.xcore.util.javafx.TooltipUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class TextFieldInputHistoryDialog {
    private static final Logger log = LoggerFactory.getLogger(TextFieldInputHistoryDialog.class);
    private ObservableList<Map<String, String>> tableData = FXCollections.observableArrayList();
    private String saveFilePath = null;
    private String[] tableColumns = null;
    private ContextMenu contextMenu = new ContextMenu();

    public TextFieldInputHistoryDialog(String saveFilePath, String ... tableColumns) {
        this.saveFilePath = saveFilePath;
        this.tableColumns = tableColumns;
        this.loadingConfigure();
    }

    public void addConfig(String ... values) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.tableColumns.length; ++i) {
            map.put(this.tableColumns[i], values[i]);
        }
        map.put("name", values[0]);
        map.put("explain", "");
        for (Map tableDatum : this.tableData) {
            boolean isEquals = true;
            for (int i = 0; i < this.tableColumns.length; ++i) {
                if (values[i].equals(tableDatum.get(this.tableColumns[i]))) continue;
                isEquals = false;
            }
            if (!isEquals) continue;
            return;
        }
        this.tableData.add(map);
        this.saveConfigure();
    }

    public void loadingConfigure() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.saveFilePath)) {
                Yaml yaml;
                List list;
                File CONFIG_FILE = new File(this.saveFilePath);
                if (!CONFIG_FILE.exists()) {
                    FileUtils.touch((File)CONFIG_FILE);
                }
                if ((list = (List)(yaml = new Yaml()).load(FileUtils.readFileToString((File)CONFIG_FILE, (String)"UTF-8"))) != null) {
                    this.tableData.addAll((Collection)list);
                }
            }
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u914d\u7f6e\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public void saveConfigure() {
        if (StringUtils.isNotEmpty((CharSequence)this.saveFilePath)) {
            try {
                File CONFIG_FILE = new File(this.saveFilePath);
                Yaml yaml = new Yaml();
                FileUtils.writeStringToFile((File)CONFIG_FILE, (String)yaml.dump(this.getTableData()), (String)"UTF-8");
                TooltipUtil.showToast("\u4fdd\u5b58\u914d\u7f6e\u6210\u529f,\u4fdd\u5b58\u5728\uff1a" + CONFIG_FILE.getPath());
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            }
        } else {
            TooltipUtil.showToast("\u672a\u6dfb\u52a0\u4fdd\u5b58\u8def\u5f84\uff01");
        }
    }

    public void setOnMouseClicked(TextField hostText, Consumer<Map<String, String>> consumer, Function<Map<String, String>, String> menuItemName) {
        hostText.setOnMouseClicked(event -> {
            if (this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            }
            this.contextMenu.getItems().clear();
            if (this.tableData != null) {
                for (Map map : this.tableData) {
                    MenuItem menu_tab = null;
                    menu_tab = menuItemName == null ? new MenuItem((String)map.get("name")) : new MenuItem((String)menuItemName.apply(map));
                    menu_tab.setOnAction(event1 -> {
                        if (consumer == null) {
                            hostText.setText((String)map.get("name"));
                        } else {
                            consumer.accept(map);
                        }
                    });
                    this.contextMenu.getItems().add((Object)menu_tab);
                }
            }
            MenuItem menu_tab = new MenuItem("\u7f16\u8f91\u5386\u53f2\u8f93\u5165");
            menu_tab.setOnAction(event1 -> {
                try {
                    this.openEditWindow();
                }
                catch (Exception e) {
                    log.error("\u52a0\u8f7d\u5386\u53f2\u8f93\u5165\u7f16\u8f91\u754c\u9762\u5931\u8d25", (Throwable)e);
                }
            });
            this.contextMenu.getItems().add((Object)menu_tab);
            this.contextMenu.show((Node)hostText, null, 0.0, hostText.getHeight());
        });
    }

    public void setTextPropertyListener(TextField hostText, Consumer<Map<String, String>> consumer, Function<Map<String, String>, String> menuItemName) {
        hostText.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            }
            this.contextMenu.getItems().clear();
            if (this.tableData != null) {
                for (Map map : this.tableData) {
                    String menuItemNameStr = null;
                    menuItemNameStr = menuItemName == null ? (String)map.get("name") : (String)menuItemName.apply(map);
                    if (!StringUtils.containsIgnoreCase((CharSequence)menuItemNameStr, (CharSequence)newValue)) continue;
                    MenuItem menu_tab = new MenuItem(menuItemNameStr);
                    menu_tab.setOnAction(event1 -> {
                        if (consumer == null) {
                            hostText.setText((String)map.get("name"));
                        } else {
                            consumer.accept(map);
                        }
                    });
                    this.contextMenu.getItems().add((Object)menu_tab);
                }
            }
            MenuItem menu_tab = new MenuItem("\u7f16\u8f91\u5386\u53f2\u8f93\u5165");
            menu_tab.setOnAction(event1 -> {
                try {
                    this.openEditWindow();
                }
                catch (Exception e) {
                    log.error("\u52a0\u8f7d\u5386\u53f2\u8f93\u5165\u7f16\u8f91\u754c\u9762\u5931\u8d25", (Throwable)e);
                }
            });
            this.contextMenu.getItems().add((Object)menu_tab);
            this.contextMenu.show((Node)hostText, null, 0.0, hostText.getHeight());
        });
    }

    public void setOnMouseClickedAndTextPropertyListener(TextField hostText, Consumer<Map<String, String>> consumer, Function<Map<String, String>, String> menuItemName) {
        this.setOnMouseClicked(hostText, consumer, menuItemName);
        this.setTextPropertyListener(hostText, consumer, menuItemName);
    }

    public void openEditWindow() {
        TableView tableView = new TableView();
        tableView.setEditable(true);
        TableColumn nameTableColumn = new TableColumn("\u540d\u79f0");
        JavaFxViewUtil.setTableColumnMapValueFactory(nameTableColumn, "name");
        tableView.getColumns().add((Object)nameTableColumn);
        for (String tableColumnName : this.tableColumns) {
            TableColumn tableColumn = new TableColumn(tableColumnName);
            JavaFxViewUtil.setTableColumnMapValueFactory(tableColumn, tableColumnName);
            tableView.getColumns().add((Object)tableColumn);
        }
        TableColumn explainTableColumn = new TableColumn("\u8bf4\u660e");
        JavaFxViewUtil.setTableColumnMapValueFactory(explainTableColumn, "explain");
        tableView.getColumns().add((Object)explainTableColumn);
        tableView.setItems(this.tableData);
        JavaFxViewUtil.addTableViewOnMouseRightClickMenu((TableView<Map<String, String>>)tableView);
        tableView.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                MenuItem menuAdd = new MenuItem("\u6dfb\u52a0\u884c");
                menuAdd.setOnAction(event1 -> tableView.getItems().add(new HashMap()));
                MenuItem menu_Copy = new MenuItem("\u590d\u5236\u9009\u4e2d\u884c");
                menu_Copy.setOnAction(event1 -> {
                    Map map = (Map)tableView.getSelectionModel().getSelectedItem();
                    HashMap map2 = new HashMap(map);
                    tableView.getItems().add(tableView.getSelectionModel().getSelectedIndex(), map2);
                });
                MenuItem menu_Remove = new MenuItem("\u5220\u9664\u9009\u4e2d\u884c");
                menu_Remove.setOnAction(event1 -> tableView.getItems().remove(tableView.getSelectionModel().getSelectedIndex()));
                MenuItem menu_RemoveAll = new MenuItem("\u5220\u9664\u6240\u6709");
                menu_RemoveAll.setOnAction(event1 -> tableView.getItems().clear());
                MenuItem menuSave = new MenuItem("\u4fdd\u5b58\u914d\u7f6e");
                menuSave.setOnAction(event1 -> {
                    try {
                        this.saveConfigure();
                    }
                    catch (Exception e) {
                        log.error("\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25", (Throwable)e);
                    }
                });
                tableView.setContextMenu(new ContextMenu(new MenuItem[]{menuAdd, menu_Copy, menu_Remove, menu_RemoveAll, menuSave}));
            }
        });
        JavaFxViewUtil.openNewWindow("\u7f16\u8f91\u5386\u53f2\u8f93\u5165", (Parent)tableView);
    }

    public ObservableList<Map<String, String>> getTableData() {
        return this.tableData;
    }

    public String getSaveFilePath() {
        return this.saveFilePath;
    }

    public String[] getTableColumns() {
        return this.tableColumns;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public void setTableData(ObservableList<Map<String, String>> tableData) {
        this.tableData = tableData;
    }

    public void setSaveFilePath(String saveFilePath) {
        this.saveFilePath = saveFilePath;
    }

    public void setTableColumns(String[] tableColumns) {
        this.tableColumns = tableColumns;
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
    }
}

