/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util.javafx;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.lang.Singleton;
import com.jfoenix.controls.JFXDecorator;
import com.xwintop.xcore.javafx.FxApp;
import com.xwintop.xcore.javafx.helper.LayoutHelper;
import com.xwintop.xcore.util.javafx.JavaFxSystemUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFxViewUtil {
    private static final Logger log = LoggerFactory.getLogger(JavaFxViewUtil.class);

    public static Stage jfxStage(Stage owner, String title, Image icon, Parent root, boolean fullScreenButton, boolean maximizeButton, boolean minimizeButton) {
        Stage newStage = new Stage();
        newStage.setTitle(title);
        newStage.setResizable(true);
        if (icon != null) {
            newStage.getIcons().add((Object)icon);
        }
        if (owner != null) {
            newStage.initOwner((Window)owner);
            newStage.initModality(Modality.WINDOW_MODAL);
            newStage.addEventHandler(WindowEvent.WINDOW_SHOWN, event -> {
                newStage.setX(owner.getX() + owner.getWidth() / 2.0 - newStage.getWidth() / 2.0);
                newStage.setY(owner.getY() + owner.getHeight() / 2.0 - newStage.getHeight() / 2.0);
            });
        } else {
            newStage.initModality(Modality.APPLICATION_MODAL);
        }
        JFXDecorator decorator = new JFXDecorator(newStage, (Node)root, fullScreenButton, maximizeButton, minimizeButton);
        decorator.setCustomMaximize(true);
        decorator.setTitle(title);
        if (icon != null) {
            decorator.setGraphic((Node)LayoutHelper.iconView(icon, 16.0));
        }
        Scene scene = new Scene((Parent)decorator);
        scene.getStylesheets().addAll(FxApp.styleSheets);
        newStage.setScene(scene);
        return newStage;
    }

    public static JFXDecorator getJFXDecorator(Stage stage, String title, String iconUrl, Parent root, boolean fullScreen, boolean max, boolean min) {
        JFXDecorator decorator = new JFXDecorator(stage, (Node)root, fullScreen, max, min);
        decorator.setCustomMaximize(true);
        decorator.setTitle(title);
        if (StringUtils.isNotEmpty((CharSequence)iconUrl)) {
            ImageView imageView = new ImageView(new Image(iconUrl));
            imageView.setFitWidth(24.0);
            imageView.setFitHeight(24.0);
            decorator.setGraphic((Node)imageView);
        }
        return decorator;
    }

    public static JFXDecorator getJFXDecorator(Stage stage, String title, String iconUrl, Parent root) {
        return JavaFxViewUtil.getJFXDecorator(stage, title, iconUrl, root, true, true, true);
    }

    public static Scene getJFXDecoratorScene(Stage stage, String title, String iconUrl, Parent root) {
        JFXDecorator decorator = JavaFxViewUtil.getJFXDecorator(stage, title, iconUrl, root);
        return JavaFxViewUtil.getJFXDecoratorScene(decorator);
    }

    public static Scene getJFXDecoratorScene(Stage stage, String title, String iconUrl, Parent root, double width, double height) {
        return JavaFxViewUtil.getJFXDecoratorScene(stage, title, iconUrl, root, width, height, true, true, true);
    }

    public static Scene getJFXDecoratorScene(Stage stage, String title, String iconUrl, Parent root, double width, double height, boolean fullScreen, boolean max, boolean min) {
        JFXDecorator decorator = JavaFxViewUtil.getJFXDecorator(stage, title, iconUrl, root, fullScreen, max, min);
        return JavaFxViewUtil.getJFXDecoratorScene(decorator, width, height);
    }

    public static Scene getJFXDecoratorScene(JFXDecorator decorator) {
        double[] screenSize = JavaFxSystemUtil.getScreenSizeByScale(0.74, 0.8);
        return JavaFxViewUtil.getJFXDecoratorScene(decorator, screenSize[0], screenSize[1]);
    }

    public static Scene getJFXDecoratorScene(JFXDecorator decorator, double width, double height) {
        Scene scene = new Scene((Parent)decorator, width, height);
        ObservableList stylesheets = scene.getStylesheets();
        URL cssUrl = JavaFxViewUtil.class.getResource("/css/jfoenix-main.css");
        if (cssUrl != null) {
            stylesheets.addAll((Object[])new String[]{cssUrl.toExternalForm()});
        }
        return scene;
    }

    public static Stage getNewStage(String title, String iconUrl, Parent root) {
        double[] screenSize = JavaFxSystemUtil.getScreenSizeByScale(0.74, 0.8);
        Stage newStage = JavaFxViewUtil.getNewStageNull(title, iconUrl, root, screenSize[0], screenSize[1], true, true, true);
        newStage.initModality(Modality.NONE);
        newStage.show();
        return newStage;
    }

    public static Stage getNewStage(String title, String iconUrl, FXMLLoader fXMLLoader) {
        Stage newStage = null;
        try {
            newStage = JavaFxViewUtil.getNewStage(title, iconUrl, (Parent)fXMLLoader.load());
            newStage.setOnCloseRequest(event -> JavaFxViewUtil.setControllerOnCloseRequest(fXMLLoader.getController(), event));
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u65b0\u7a97\u53e3\u5931\u8d25", (Throwable)e);
        }
        return newStage;
    }

    public static void openNewWindow(String title, Parent root) {
        double[] screenSize = JavaFxSystemUtil.getScreenSizeByScale(0.74, 0.8);
        JavaFxViewUtil.openNewWindow(title, null, root, screenSize[0], screenSize[1], true, true, true);
    }

    public static void openNewWindow(String title, String iconUrl, Parent root, double width, double height, boolean fullScreen, boolean max, boolean min) {
        Stage newStage = JavaFxViewUtil.getNewStageNull(title, iconUrl, root, width, height, fullScreen, max, min);
        newStage.initModality(Modality.APPLICATION_MODAL);
        newStage.show();
    }

    public static Stage getNewStageNull(String title, String iconUrl, Parent root, double width, double height, boolean fullScreen, boolean max, boolean min) {
        Stage newStage = new Stage();
        newStage.setTitle(title);
        newStage.setResizable(true);
        Scene scene = JavaFxViewUtil.getJFXDecoratorScene(newStage, title, iconUrl, root, width, height, fullScreen, max, min);
        newStage.setScene(scene);
        if (StringUtils.isNotEmpty((CharSequence)iconUrl)) {
            newStage.getIcons().add((Object)new Image(iconUrl));
        }
        return newStage;
    }

    public static void openUrlOnWebView(String url, String title, String iconUrl) {
        WebView browser = new WebView();
        WebEngine webEngine = browser.getEngine();
        if (url.startsWith("http")) {
            webEngine.load(url);
        } else {
            webEngine.load(JavaFxViewUtil.class.getResource(url).toExternalForm());
        }
        JavaFxViewUtil.getNewStage(title, iconUrl, (Parent)new BorderPane((Node)browser));
    }

    public static void setControllerOnCloseRequest(Object controller, Event event) {
        try {
            Method method = MethodUtils.getAccessibleMethod(controller.getClass(), (String)"onCloseRequest", (Class[])new Class[]{Event.class});
            if (method != null) {
                MethodUtils.invokeMethod((Object)controller, (String)"onCloseRequest", (Object[])new Object[]{event});
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884conCloseRequest\u65b9\u6cd5\u5931\u8d25", (Throwable)e);
        }
    }

    public static void setSpinnerValueFactory(Spinner<Integer> spinner, int min, int max) {
        JavaFxViewUtil.setSpinnerValueFactory(spinner, min, max, min, 1);
    }

    public static void setSpinnerValueFactory(Spinner<Integer> spinner, int min, int max, int initialValue) {
        JavaFxViewUtil.setSpinnerValueFactory(spinner, min, max, initialValue, 1);
    }

    public static void setSpinnerValueFactory(Spinner<Double> spinner, double min, double max) {
        JavaFxViewUtil.setSpinnerValueFactory(spinner, min, max, min, 1.0);
    }

    public static void setSpinnerValueFactory(Spinner<Double> spinner, double min, double max, double initialValue) {
        JavaFxViewUtil.setSpinnerValueFactory(spinner, min, max, initialValue, 1.0);
    }

    public static void setSpinnerValueFactory(Spinner spinner, Number min, Number max, Number initialValue, Number amountToStepBy) {
        if (min instanceof Integer) {
            SpinnerValueFactory.IntegerSpinnerValueFactory secondStart_0svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(((Integer)min).intValue(), ((Integer)max).intValue(), ((Integer)initialValue).intValue(), ((Integer)amountToStepBy).intValue());
            spinner.setValueFactory((SpinnerValueFactory)secondStart_0svf);
            spinner.getEditor().textProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    spinner.getValueFactory().setValue((Object)Integer.parseInt(newValue));
                }
                catch (Exception e) {
                    log.warn("\u6570\u5b57int\u8f6c\u6362\u5f02\u5e38 newValue:" + newValue);
                    spinner.getEditor().setText(oldValue);
                }
            });
        } else if (min instanceof Double) {
            SpinnerValueFactory.DoubleSpinnerValueFactory secondStart_0svf = new SpinnerValueFactory.DoubleSpinnerValueFactory(((Double)min).doubleValue(), ((Double)max).doubleValue(), ((Double)initialValue).doubleValue(), ((Double)amountToStepBy).doubleValue());
            spinner.setValueFactory((SpinnerValueFactory)secondStart_0svf);
            spinner.getEditor().textProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    spinner.getValueFactory().setValue((Object)Double.parseDouble(newValue));
                }
                catch (Exception e) {
                    log.warn("\u6570\u5b57double\u8f6c\u6362\u5f02\u5e38 newValue:" + newValue);
                    spinner.getEditor().setText(oldValue);
                }
            });
        }
    }

    public static void setSliderLabelFormatter(Slider slider, final String formatter) {
        slider.setLabelFormatter((StringConverter)new StringConverter<Double>(){

            public String toString(Double object) {
                DecimalFormat decimalFormat = new DecimalFormat(formatter);
                return decimalFormat.format(object);
            }

            public Double fromString(String string) {
                return Double.valueOf(string);
            }
        });
    }

    public static void addTableViewOnMouseRightClickMenu(TableView<Map<String, String>> tableView) {
        tableView.setEditable(true);
        tableView.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                MenuItem menuAdd = new MenuItem("\u6dfb\u52a0\u884c");
                menuAdd.setOnAction(event1 -> tableView.getItems().add(new HashMap()));
                MenuItem menu_Copy = new MenuItem("\u590d\u5236\u9009\u4e2d\u884c");
                menu_Copy.setOnAction(event1 -> {
                    Map map = (Map)tableView.getSelectionModel().getSelectedItem();
                    HashMap map2 = new HashMap(map);
                    tableView.getItems().add(tableView.getSelectionModel().getSelectedIndex(), map2);
                });
                MenuItem menu_Remove = new MenuItem("\u5220\u9664\u9009\u4e2d\u884c");
                menu_Remove.setOnAction(event1 -> tableView.getItems().remove(tableView.getSelectionModel().getSelectedIndex()));
                MenuItem menu_RemoveAll = new MenuItem("\u5220\u9664\u6240\u6709");
                menu_RemoveAll.setOnAction(event1 -> tableView.getItems().clear());
                tableView.setContextMenu(new ContextMenu(new MenuItem[]{menuAdd, menu_Copy, menu_Remove, menu_RemoveAll}));
            }
        });
    }

    public static void addListViewOnMouseRightClickMenu(ListView<String> listView) {
        listView.setEditable(true);
        listView.setCellFactory(TextFieldListCell.forListView());
        listView.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                MenuItem menuAdd = new MenuItem("\u6dfb\u52a0\u884c");
                menuAdd.setOnAction(event1 -> listView.getItems().add((Object)""));
                MenuItem menu_Copy = new MenuItem("\u590d\u5236\u9009\u4e2d\u884c");
                menu_Copy.setOnAction(event1 -> listView.getItems().add(listView.getSelectionModel().getSelectedIndex(), listView.getSelectionModel().getSelectedItem()));
                MenuItem menu_Remove = new MenuItem("\u5220\u9664\u9009\u4e2d\u884c");
                menu_Remove.setOnAction(event1 -> listView.getItems().remove(listView.getSelectionModel().getSelectedIndex()));
                MenuItem menu_RemoveAll = new MenuItem("\u5220\u9664\u6240\u6709");
                menu_RemoveAll.setOnAction(event1 -> listView.getItems().clear());
                listView.setContextMenu(new ContextMenu(new MenuItem[]{menuAdd, menu_Copy, menu_Remove, menu_RemoveAll}));
            }
        });
    }

    public static void setTableColumnMapValueFactory(TableColumn tableColumn, String name) {
        JavaFxViewUtil.setTableColumnMapValueFactory(tableColumn, name, true, null);
    }

    public static void setTableColumnMapValueFactory(TableColumn tableColumn, String name, boolean isEdit) {
        JavaFxViewUtil.setTableColumnMapValueFactory(tableColumn, name, isEdit, null);
    }

    public static void setTableColumnMapValueFactory(TableColumn tableColumn, final String name, boolean isEdit, final Runnable onEditCommitHandle) {
        tableColumn.setCellValueFactory((Callback)new MapValueFactory((Object)name));
        tableColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        if (isEdit) {
            tableColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Map<String, String>, String>>(){

                public void handle(TableColumn.CellEditEvent<Map<String, String>, String> t) {
                    ((Map)t.getRowValue()).put(name, t.getNewValue());
                    if (onEditCommitHandle != null) {
                        onEditCommitHandle.run();
                    }
                }
            });
        }
    }

    public static void setTableColumnButonFactory(TableColumn tableColumn, String name, EventHandler<? super MouseEvent> value) {
        JavaFxViewUtil.setTableColumnButonFactory(tableColumn, name, (MouseEvent mouseEvent, Integer index) -> value.handle((Event)mouseEvent));
    }

    public static void setTableColumnButonFactory(TableColumn tableColumn, final String name, final MouseEventCallFunc mouseEventCallFunc) {
        tableColumn.setCellFactory(col -> {
            TableCell<Object, Boolean> cell = new TableCell<Object, Boolean>(){

                public void updateItem(Boolean item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setText(null);
                    this.setGraphic(null);
                    if (!empty) {
                        Button delBtn = new Button(name);
                        this.setContentDisplay(ContentDisplay.CENTER);
                        this.setGraphic((Node)delBtn);
                        delBtn.setOnMouseClicked(me -> mouseEventCallFunc.callFun((MouseEvent)me, this.getIndex()));
                    }
                }
            };
            return cell;
        });
    }

    public static void setTableColumnMapAsChoiceBoxValueFactory(final TableColumn tableColumn, final String name, final String[] choiceBoxStrings) {
        tableColumn.setCellValueFactory((Callback)new MapValueFactory((Object)name));
        tableColumn.setCellFactory((Callback)new Callback<TableColumn<Map<String, String>, String>, TableCell<Map<String, String>, String>>(){

            public TableCell<Map<String, String>, String> call(TableColumn<Map<String, String>, String> param) {
                TableCell<Map<String, String>, String> cell = new TableCell<Map<String, String>, String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setGraphic(null);
                        if (!empty) {
                            ObservableList tableData = tableColumn.getTableView().getItems();
                            ChoiceBox choiceBox = new ChoiceBox();
                            choiceBox.getItems().addAll((Object[])choiceBoxStrings);
                            choiceBox.setValue(((Map)tableData.get(this.getIndex())).get(name));
                            choiceBox.valueProperty().addListener((obVal, oldVal, newVal) -> ((Map)tableData.get(this.getIndex())).put(name, newVal));
                            this.setGraphic((Node)choiceBox);
                        }
                    }
                };
                return cell;
            }
        });
    }

    public static void setTableColumnMapAsCheckBoxValueFactory(TableColumn tableColumn, String name) {
        JavaFxViewUtil.setTableColumnMapAsCheckBoxValueFactory(tableColumn, name, null);
    }

    public static void setTableColumnMapAsCheckBoxValueFactory(final TableColumn tableColumn, final String name, final MouseEventCallFunc mouseEventCallFunc) {
        tableColumn.setCellValueFactory((Callback)new MapValueFactory((Object)name));
        tableColumn.setCellFactory((Callback)new Callback<TableColumn<Map<String, String>, String>, TableCell<Map<String, String>, String>>(){

            public TableCell<Map<String, String>, String> call(TableColumn<Map<String, String>, String> param) {
                TableCell<Map<String, String>, String> cell = new TableCell<Map<String, String>, String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setGraphic(null);
                        if (!empty) {
                            ObservableList tableData = tableColumn.getTableView().getItems();
                            CheckBox checkBox = new CheckBox();
                            checkBox.setSelected(Boolean.valueOf((String)((Map)tableData.get(this.getIndex())).get(name)).booleanValue());
                            checkBox.selectedProperty().addListener((obVal, oldVal, newVal) -> {
                                ((Map)tableData.get(this.getIndex())).put(name, newVal.toString());
                                if (mouseEventCallFunc != null) {
                                    mouseEventCallFunc.callFun(null, this.getIndex());
                                }
                            });
                            this.setGraphic((Node)checkBox);
                        }
                    }
                };
                return cell;
            }
        });
    }

    public static void setPropertyAddChangeListener(TextInputControl inputControl, Consumer<ActionEvent> consumer) {
        inputControl.textProperty().addListener((observable, oldValue, newValue) -> {
            if (((TimedCache)Singleton.get(TimedCache.class, (Object[])new Object[]{2000L})).get((Object)"initiativeChange") != null) {
                return;
            }
            ((TimedCache)Singleton.get(TimedCache.class, (Object[])new Object[]{2000L})).put((Object)"initiativeChange", (Object)true);
            consumer.accept(null);
            ((TimedCache)Singleton.get(TimedCache.class, (Object[])new Object[]{2000L})).remove((Object)"initiativeChange");
        });
    }

    public static void setPropertyAddChangeListener(TextInputControl inputControl, Runnable runnable) {
        inputControl.textProperty().addListener((observable, oldValue, newValue) -> JavaFxViewUtil.setPropertyChangeRun(runnable));
    }

    public static void setPropertyChangeRun(Runnable runnable) {
        if (((TimedCache)Singleton.get(TimedCache.class, (Object[])new Object[]{2000L})).get((Object)"initiativeChange") != null) {
            return;
        }
        ((TimedCache)Singleton.get(TimedCache.class, (Object[])new Object[]{2000L})).put((Object)"initiativeChange", (Object)true);
        runnable.run();
        ((TimedCache)Singleton.get(TimedCache.class, (Object[])new Object[]{2000L})).remove((Object)"initiativeChange");
    }

    public static void setPasswordTextFieldFactory(PasswordField passwordTextField) {
        TextField password2TextField = new TextField(passwordTextField.getText());
        password2TextField.setVisible(false);
        RadioButton passwordRadioButton = new RadioButton();
        passwordTextField.textProperty().addListener((observable, oldValue, newValue) -> password2TextField.setText(newValue));
        password2TextField.textProperty().addListener((observable, oldValue, newValue) -> passwordTextField.setText(newValue));
        passwordRadioButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            passwordTextField.setVisible(newValue == false);
            password2TextField.setVisible(newValue.booleanValue());
        });
        StackPane stackPane = (StackPane)passwordTextField.getParent();
        stackPane.getChildren().add((Object)password2TextField);
        stackPane.getChildren().add((Object)passwordRadioButton);
        StackPane.setAlignment((Node)passwordRadioButton, (Pos)Pos.CENTER_RIGHT);
    }

    public static void addMenuItem(ContextMenu contextMenu, String text, EventHandler<ActionEvent> value) {
        MenuItem menuItem = new MenuItem(text);
        menuItem.setOnAction(value);
        contextMenu.getItems().add((Object)menuItem);
    }

    public static interface MouseEventCallFunc {
        public void callFun(MouseEvent var1, Integer var2);
    }
}

