/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util.javafx;

import com.xwintop.xcore.util.FileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;

public class ImageUtil {
    public static BufferedImage getBufferedImage(String path) {
        return ImageUtil.getBufferedImage(new File(path));
    }

    public static BufferedImage getBufferedImage(File file) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = Imaging.getBufferedImage((File)file);
        }
        catch (Exception e) {
            try {
                bufferedImage = ImageIO.read(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return bufferedImage;
    }

    public static Image getFXImage(String path) {
        return ImageUtil.getFXImage(new File(path));
    }

    public static Image getFXImage(File file) {
        WritableImage image = null;
        try {
            image = SwingFXUtils.toFXImage((BufferedImage)Imaging.getBufferedImage((File)file), null);
        }
        catch (Exception e) {
            image = new Image("file:" + file.getAbsolutePath());
        }
        return image;
    }

    public static Image getFXImage(byte[] bytes) {
        WritableImage image = null;
        try {
            image = SwingFXUtils.toFXImage((BufferedImage)Imaging.getBufferedImage((byte[])bytes), null);
        }
        catch (Exception e) {
            image = new Image((InputStream)new ByteArrayInputStream(bytes));
        }
        return image;
    }

    public static void writeImage(Image image, File file) throws Exception {
        ImageUtil.writeImage(SwingFXUtils.fromFXImage((Image)image, null), file);
    }

    public static void writeImage(BufferedImage bufferedImage, File file) throws Exception {
        try {
            Imaging.writeImage((BufferedImage)bufferedImage, (File)file, (ImageFormat)ImageFormats.valueOf((String)FileUtil.getFileSuffixName(file).toUpperCase()), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            ImageIO.write((RenderedImage)bufferedImage, FileUtil.getFileSuffixName(file), file);
        }
    }
}

