/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util.javafx;

import com.xwintop.xcore.javafx.helper.DropContentHelper;
import com.xwintop.xcore.util.FileUtil;
import java.io.File;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.filechooser.FileSystemView;

public class FileChooserUtil {
    public static final File HOME_DIRECTORY = FileSystemView.getFileSystemView().getHomeDirectory();

    public static File chooseFile() {
        return FileChooserUtil.chooseFile(null);
    }

    public static File chooseFile(FileChooser.ExtensionFilter ... extensionFilter) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("\u8bf7\u9009\u62e9\u6587\u4ef6");
        fileChooser.setInitialDirectory(HOME_DIRECTORY);
        if (extensionFilter != null) {
            fileChooser.getExtensionFilters().addAll((Object[])extensionFilter);
        }
        return fileChooser.showOpenDialog(null);
    }

    public static File chooseSaveFile(FileChooser.ExtensionFilter ... extensionFilter) {
        return FileChooserUtil.chooseSaveFile(null, extensionFilter);
    }

    public static File chooseSaveFile(String fileName) {
        return FileChooserUtil.chooseSaveFile(fileName, null);
    }

    public static File chooseSaveFile(String fileName, FileChooser.ExtensionFilter ... extensionFilter) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(HOME_DIRECTORY);
        if (fileName != null) {
            fileChooser.setInitialFileName(fileName);
        }
        if (extensionFilter != null) {
            fileChooser.getExtensionFilters().addAll((Object[])extensionFilter);
        }
        return fileChooser.showSaveDialog(null);
    }

    public static File chooseSaveCommonImageFile(String fileName) {
        return FileChooserUtil.chooseSaveFile(fileName, new FileChooser.ExtensionFilter("All Images", new String[]{"*.*"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"}), new FileChooser.ExtensionFilter("GIF", new String[]{"*.gif"}), new FileChooser.ExtensionFilter("JPEG", new String[]{"*.jpeg"}), new FileChooser.ExtensionFilter("BMP", new String[]{"*.bmp"}));
    }

    public static File chooseSaveImageFile(String fileName) {
        return FileChooserUtil.chooseSaveFile(fileName, new FileChooser.ExtensionFilter("All Images", new String[]{"*.*"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"}), new FileChooser.ExtensionFilter("gif", new String[]{"*.gif"}), new FileChooser.ExtensionFilter("jpeg", new String[]{"*.jpeg"}), new FileChooser.ExtensionFilter("bmp", new String[]{"*.bmp"}), new FileChooser.ExtensionFilter("ICO", new String[]{"*.ico"}), new FileChooser.ExtensionFilter("RGBE", new String[]{"*.rgbe"}));
    }

    public static File chooseDirectory() {
        return FileChooserUtil.chooseDirectory(null);
    }

    public static File chooseDirectory(File initialDirectory) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        if (initialDirectory != null) {
            directoryChooser.setInitialDirectory(initialDirectory);
        }
        return directoryChooser.showDialog(null);
    }

    public static void setOnDrag(TextField textField, FileType fileType) {
        DropContentHelper.accept(textField, dragboard -> {
            if (!dragboard.hasFiles()) return false;
            if (!dragboard.getFiles().stream().anyMatch(fileType::match)) return false;
            return true;
        }, (__, dragboard) -> textField.setText(dragboard.getFiles().stream().filter(fileType::match).map(File::getAbsolutePath).findFirst().orElse("")));
    }

    public static void setOnDragByOpenFile(TextInputControl textField) {
        DropContentHelper.accept(textField, dragboard -> dragboard.hasFiles() && dragboard.getFiles().stream().anyMatch(File::isFile), (__, dragboard) -> textField.setText(dragboard.getFiles().stream().filter(File::isFile).map(FileUtil::readText).findFirst().orElse("")));
    }

    public static enum FileType {
        FILE,
        FOLDER;


        public boolean match(File file) {
            return this == FILE && file.isFile() || this == FOLDER && file.isDirectory();
        }
    }
}

