/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClientUtil {
    public static final Duration DEFAULT_CALL_TIMEOUT = Duration.ofMinutes(2L);
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofMinutes(2L);
    public static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(2L);
    public static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofMinutes(2L);
    private static OkHttpClient okHttpClient = null;

    public static void reinitialize(Duration connectTimeout, Duration readTimeout, Duration writeTimeout, Duration callTimeout) {
        okHttpClient = new OkHttpClient.Builder().connectTimeout(connectTimeout).readTimeout(readTimeout).writeTimeout(writeTimeout).callTimeout(callTimeout).build();
    }

    public static String executeGet(HttpUrl url, Headers headers, Charset charset) throws IOException {
        return HttpClientUtil.execute(url, headers, charset, Request.Builder::get);
    }

    public static String executePost(HttpUrl url, Headers headers, Charset charset, RequestBody body) throws IOException {
        return HttpClientUtil.execute(url, headers, charset, builder -> builder.post(body));
    }

    public static String execute(HttpUrl url, Headers headers, Charset charset, Consumer<Request.Builder> builderConsumer) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(url).headers(headers);
        builderConsumer.accept(requestBuilder);
        Request request = requestBuilder.build();
        try (Response response = okHttpClient.newCall(request).execute();){
            if (response.body() != null) {
                String string = new String(response.body().bytes(), charset);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Deprecated
    public static String getHttpDataAsUTF_8(String url, String refererUrl) {
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Referer", refererUrl);
            Request request = new Request.Builder().url(url).headers(Headers.of(headerMap)).build();
            Response response = okHttpClient.newCall(request).execute();
            return response.body().string();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static String getHttpDataByPost(String url, String refererUrl, Map<String, String> map) {
        try {
            FormBody.Builder builder = new FormBody.Builder();
            map.forEach((key, value) -> {
                if (value != null) {
                    builder.add(key, value);
                }
            });
            FormBody body = builder.build();
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Referer", refererUrl);
            Request request = new Request.Builder().url(url).post((RequestBody)body).headers(Headers.of(headerMap)).build();
            Response response = okHttpClient.newCall(request).execute();
            return response.body().string();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static String getHttpDataByPost(String url, String refererUrl, String string) {
        return HttpClientUtil.getHttpDataByPost(url, refererUrl, string, "text/x-markdown; charset=utf-8");
    }

    @Deprecated
    public static String getHttpDataByPost(String url, String refererUrl, String string, String header) {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)header), (String)string);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Referer", refererUrl);
            Request request = new Request.Builder().url(url).post(body).headers(Headers.of(headerMap)).build();
            Response response = okHttpClient.newCall(request).execute();
            return response.body().string();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void openBrowseURL(String url) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(url));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void openBrowseURLThrowsException(String url) throws IOException, URISyntaxException {
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(new URI(url));
    }

    static {
        HttpClientUtil.reinitialize(DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT, DEFAULT_WRITE_TIMEOUT, DEFAULT_CALL_TIMEOUT);
    }
}

