/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    public static String readText(File file, Charset charset) {
        try {
            return new String(Files.readAllBytes(file.toPath()), charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String readText(File file) {
        return FileUtil.readText(file, Charset.defaultCharset());
    }

    public static String[] getFileNames(File file) {
        String fileName = file.getName();
        return new String[]{StringUtils.substringBeforeLast((String)fileName, (String)"."), StringUtils.substringAfterLast((String)fileName, (String)".")};
    }

    public static String getFileName(File file) {
        return FileUtil.getFileNames(file)[0];
    }

    public static String getFileSuffixName(File file) {
        return FileUtil.getFileNames(file)[1];
    }

    public static String getFileSuffixNameAndDot(File file) {
        String suffixName = FileUtil.getFileNames(file)[1];
        if (!"".equals(suffixName)) {
            suffixName = "." + suffixName;
        }
        return suffixName;
    }

    public static String getRandomFileName(File file) {
        String[] fileNames = FileUtil.getFileNames(file);
        String fileName = fileNames[0] + ("" + System.currentTimeMillis()).substring(9);
        if (!"".equals(fileNames[1])) {
            fileName = fileName + "." + fileNames[1];
        }
        return fileName;
    }

    public static String formatFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.000");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "K" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "M" : df.format((double)fileS / 1.073741824E9) + "G"));
        return fileSizeString;
    }
}

