/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util;

import com.xwintop.xcore.util.KeyValue;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class EnumUtil {
    public static <T extends Enum<T>> List<KeyValue<String, T>> toKeyValueList(Class<T> enumType) {
        return EnumUtil.toKeyValueList(enumType, Enum::name);
    }

    public static <T extends Enum<T>> List<KeyValue<String, T>> toKeyValueList(Class<T> enumType, Function<T, String> toString) {
        ArrayList list = new ArrayList();
        EnumSet.allOf(enumType).forEach(value -> list.add(new KeyValue(toString.apply(value), (Enum)value)));
        return list;
    }

    public static <T extends Enum<T>> List<KeyValue<String, T>> toKeyValueList(T ... values) {
        ArrayList list = new ArrayList();
        Stream.of(values).forEach(value -> list.add(new KeyValue<String, Enum>(value.name(), (Enum)value)));
        return list;
    }
}

