/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx.wrapper;

import javafx.scene.Node;
import javafx.scene.control.ContextMenu;

public class ContextMenuWrapper {
    private final ContextMenu contextMenu;

    public static ContextMenuWrapper of(ContextMenu contextMenu) {
        return new ContextMenuWrapper(contextMenu);
    }

    private ContextMenuWrapper(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
    }

    public <T extends Node> T wrap(T node) {
        node.setOnContextMenuRequested(event -> {
            if (this.contextMenu != null && event.getSource() instanceof Node) {
                this.contextMenu.show((Node)event.getSource(), event.getScreenX(), event.getScreenY());
            }
        });
        return node;
    }
}

