/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx.wrapper;

import com.xwintop.xcore.util.CssProps;
import javafx.scene.Node;

public class BorderWrapper {
    private String color;
    private BorderStyle borderStyle;
    private double width;

    public static BorderWrapper of(String color, BorderStyle style, double width) {
        return new BorderWrapper(color, style, width);
    }

    private BorderWrapper(String color, BorderStyle borderStyle, double width) {
        this.color = color;
        this.borderStyle = borderStyle;
        this.width = width;
    }

    public <T extends Node> T wrap(T node) {
        CssProps cssProps = new CssProps().put("-fx-border-style", this.borderStyle.name()).put("-fx-border-color", this.color).put("-fx-border-width", String.valueOf(this.width));
        cssProps.applyTo(node);
        return node;
    }

    public static enum BorderStyle {
        none,
        solid,
        dotted,
        dashed;

    }
}

