/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx.stage;

import com.jfoenix.controls.JFXDecorator;
import com.xwintop.xcore.javafx.FxApp;
import com.xwintop.xcore.javafx.helper.LayoutHelper;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class StageWrapper {
    public static Stage jfxStage(Stage owner, String title, Image icon, Parent root, boolean fullScreenButton, boolean maximizeButton, boolean minimizeButton) {
        Stage newStage = new Stage();
        newStage.setTitle(title);
        newStage.setResizable(true);
        if (icon != null) {
            newStage.getIcons().add((Object)icon);
        }
        StageWrapper.wrapStage(newStage, owner, title, icon, root, fullScreenButton, maximizeButton, minimizeButton);
        return newStage;
    }

    public static void wrapStage(Stage newStage, Stage owner, String title, Image icon, Parent root, boolean fullScreenButton, boolean maximizeButton, boolean minimizeButton) {
        if (owner != null) {
            newStage.initOwner((Window)owner);
            newStage.initModality(Modality.WINDOW_MODAL);
            newStage.addEventHandler(WindowEvent.WINDOW_SHOWN, event -> {
                newStage.setX(owner.getX() + owner.getWidth() / 2.0 - newStage.getWidth() / 2.0);
                newStage.setY(owner.getY() + owner.getHeight() / 2.0 - newStage.getHeight() / 2.0);
            });
        } else {
            newStage.initModality(Modality.APPLICATION_MODAL);
        }
        JFXDecorator decorator = new JFXDecorator(newStage, (Node)root, fullScreenButton, maximizeButton, minimizeButton);
        decorator.setCustomMaximize(true);
        decorator.setTitle(title);
        if (icon != null) {
            decorator.setGraphic((Node)LayoutHelper.iconView(icon, 16.0));
        }
        Scene scene = new Scene((Parent)decorator);
        scene.getStylesheets().addAll(FxApp.styleSheets);
        newStage.setScene(scene);
    }
}

