/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx.helper;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class DropContentHelper {
    public static <T extends Node> void acceptText(T node, BiConsumer<T, String> onAccept) {
        node.setOnDragOver(event -> {
            Dragboard board = event.getDragboard();
            if (board.hasString() || board.hasHtml() || board.hasRtf() || board.hasUrl()) {
                event.acceptTransferModes(TransferMode.ANY);
            } else {
                event.acceptTransferModes(TransferMode.NONE);
            }
        });
        node.setOnDragDropped(event -> {
            Dragboard dragboard = event.getDragboard();
            if (dragboard.hasString()) {
                onAccept.accept(node, dragboard.getString());
            } else if (dragboard.hasHtml()) {
                onAccept.accept(node, dragboard.getHtml());
            } else if (dragboard.hasRtf()) {
                onAccept.accept(node, dragboard.getRtf());
            } else if (dragboard.hasUrl()) {
                onAccept.accept(node, dragboard.getUrl());
            }
        });
    }

    public static <T extends Node> void acceptFile(T node, BiConsumer<T, List<File>> onAccept) {
        node.setOnDragOver(event -> {
            if (event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.ANY);
            } else {
                event.acceptTransferModes(TransferMode.NONE);
            }
        });
        node.setOnDragDropped(event -> {
            Dragboard dragboard = event.getDragboard();
            if (dragboard.hasFiles()) {
                onAccept.accept(node, dragboard.getFiles());
            }
        });
    }

    public static <T extends Node> void accept(T node, Predicate<Dragboard> predicate, BiConsumer<T, Dragboard> onAccept) {
        node.setOnDragOver(event -> {
            if (predicate.test(event.getDragboard())) {
                event.acceptTransferModes(TransferMode.ANY);
            } else {
                event.acceptTransferModes(TransferMode.NONE);
            }
        });
        node.setOnDragDropped(event -> {
            Dragboard dragboard = event.getDragboard();
            onAccept.accept(node, dragboard);
        });
    }
}

