/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx.helper;

import com.xwintop.xcore.util.EnumUtil;
import com.xwintop.xcore.util.KeyValue;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.control.ChoiceBox;
import javafx.util.StringConverter;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class ChoiceBoxHelper {
    public static <T extends Enum<T>> void setContentDisplay(ChoiceBox<T> choiceBox, Class<T> enumType, Function<T, String> toString) {
        List<KeyValue<String, T>> keyValues = EnumUtil.toKeyValueList(enumType, toString);
        ChoiceBoxHelper.setContentDisplay(choiceBox, keyValues);
    }

    public static <T> void setContentDisplay(ChoiceBox<T> choiceBox, KeyValue<String, T> ... keyValues) {
        ChoiceBoxHelper.setContentDisplay(choiceBox, Arrays.asList(keyValues));
    }

    public static <T> void setContentDisplay(ChoiceBox<T> choiceBox, List<KeyValue<String, T>> keyValues) {
        List values = keyValues.stream().map(KeyValue::getValue).collect(Collectors.toList());
        DualHashBidiMap map = new DualHashBidiMap();
        keyValues.forEach(arg_0 -> ChoiceBoxHelper.lambda$setContentDisplay$0((BidiMap)map, arg_0));
        ChoiceBoxHelper.setContentDisplay(choiceBox, values, map);
    }

    public static <T> void setContentDisplay(ChoiceBox<T> choiceBox, List<T> items, final BidiMap<String, T> itemMappings) {
        choiceBox.setConverter(new StringConverter<T>(){

            public String toString(T object) {
                return (String)itemMappings.getKey(object);
            }

            public T fromString(String string) {
                return itemMappings.get((Object)string);
            }
        });
        choiceBox.getItems().addAll(items);
    }

    private static /* synthetic */ void lambda$setContentDisplay$0(BidiMap map, KeyValue keyValue) {
        map.put(keyValue.getKey(), keyValue.getValue());
    }
}

