/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx.dialog;

import com.xwintop.xcore.javafx.FxApp;
import com.xwintop.xcore.javafx.dialog.FxDialog;
import com.xwintop.xcore.javafx.dialog.ProgressTask;
import com.xwintop.xcore.javafx.helper.LayoutHelper;
import java.text.DecimalFormat;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class FxProgressDialog {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.00%");
    private final ProgressTask progressTask;
    private final Window owner;
    private final Label messageLabel = new Label();
    private final Label progressLabel = new Label();
    private boolean showAsPercentage = true;
    private boolean decorated = true;

    public static FxProgressDialog create(Window owner, ProgressTask progressTask, String message) {
        return new FxProgressDialog(owner, progressTask, message);
    }

    private FxProgressDialog(Window owner, ProgressTask progressTask, String message) {
        this.owner = owner;
        this.progressTask = progressTask;
        progressTask.updateMessage(message);
    }

    public void setDecorated(boolean decorated) {
        this.decorated = decorated;
    }

    public void setShowAsPercentage(boolean showAsPercentage) {
        this.showAsPercentage = showAsPercentage;
    }

    public void show() {
        this.show0(false);
    }

    public void showAndWait() {
        this.show0(true);
    }

    private void show0(boolean wait) {
        Service<Void> service = new Service<Void>(){

            protected Task<Void> createTask() {
                return FxProgressDialog.this.progressTask;
            }
        };
        FxDialog fxDialog = new FxDialog().setOwner(this.owner).setBody(this.progressBody(this.progressTask)).setButtonTypes(ButtonType.CANCEL).setButtonHandler(ButtonType.CANCEL, (arg_0, arg_1) -> FxProgressDialog.lambda$show0$0((Service)service, arg_0, arg_1)).setCloseable(false).withStage(arg_0 -> this.lambda$show0$5((Service)service, arg_0));
        if (wait) {
            fxDialog.showAndWait();
        } else {
            fxDialog.show();
        }
    }

    private Parent progressBody(ProgressTask progressTask) {
        ProgressBar progressBar = new ProgressBar();
        progressBar.setPrefHeight(25.0);
        progressBar.setPrefWidth(300.0);
        progressTask.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress(progressTask, progressBar, this.progressLabel));
        this.messageLabel.textProperty().bind((ObservableValue)progressTask.messageProperty());
        return LayoutHelper.vbox(0.0, 5.0, Pos.CENTER, new Node[]{LayoutHelper.hbox(5.0, 0.0, new Node[]{this.messageLabel}), new StackPane(new Node[]{progressBar, this.progressLabel})});
    }

    private void updateProgress(ProgressTask progressTask, ProgressBar progressBar, Label progressLabel) {
        FxApp.runLater(() -> {
            double progress = progressTask.getProgress();
            progressBar.setProgress(progress);
            if (this.showAsPercentage) {
                progressLabel.setText(FORMAT.format(progress));
            } else if (progressTask.getTotalWork() <= 1.0) {
                progressLabel.setText(String.format("%f / %f", progressTask.getWorkDone(), progressTask.getTotalWork()));
            } else {
                progressLabel.setText(String.format("%d / %d", (int)progressTask.getWorkDone(), (int)progressTask.getTotalWork()));
            }
        });
    }

    private /* synthetic */ void lambda$show0$5(Service service, Stage stage) {
        if (!this.decorated) {
            stage.initStyle(StageStyle.UNDECORATED);
        }
        stage.addEventHandler(WindowEvent.WINDOW_SHOWN, event -> service.start());
        service.setOnSucceeded(event -> stage.close());
        service.setOnCancelled(event -> stage.close());
        service.setOnFailed(event -> stage.close());
    }

    private static /* synthetic */ void lambda$show0$0(Service service, ActionEvent event, Stage stage) {
        service.cancel();
    }
}

