/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx.dialog;

import com.xwintop.xcore.javafx.FxApp;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FxAlerts {
    public static void error(String message) {
        FxAlerts.alert(Alert.AlertType.ERROR, "\u9519\u8bef", message);
    }

    public static void error(String title, String message) {
        FxAlerts.alert(Alert.AlertType.ERROR, title, message);
    }

    public static void error(String title, Throwable throwable) {
        boolean noMessage = StringUtils.isBlank((CharSequence)throwable.getMessage());
        String message = noMessage ? throwable.toString() : throwable.getMessage();
        FxAlerts.error(title, message, ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    public static void info(String title, String message) {
        FxAlerts.alert(Alert.AlertType.INFORMATION, title, message);
    }

    public static void warn(String title, String message) {
        FxAlerts.alert(Alert.AlertType.WARNING, title, message);
    }

    public static void alert(Alert.AlertType alertType, String title, String message) {
        FxApp.runLater(() -> {
            try {
                Alert alert = new Alert(alertType, message, new ButtonType[]{ButtonType.OK});
                alert.setTitle(title);
                alert.setHeaderText(null);
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                FxApp.setupIcon(stage);
                FxApp.setupModality(alert);
                alert.showAndWait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void error(String title, String message, String details) {
        FxApp.runLater(() -> FxAlerts.error0(title, message, details));
    }

    private static void error0(String title, String message, String details) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message.trim());
        TextArea textArea = new TextArea(details);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)textArea, 0, 0);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
        FxApp.setupIcon(stage);
        FxApp.setupModality(alert);
        alert.showAndWait();
    }

    public static boolean confirmOkCancel(String title, String message) {
        return FxAlerts.confirm(Alert.AlertType.CONFIRMATION, title, message, ButtonType.OK, ButtonType.CANCEL) == ButtonType.OK;
    }

    public static boolean confirmYesNo(String title, String message) {
        return FxAlerts.confirm(Alert.AlertType.WARNING, title, message, ButtonType.YES, ButtonType.NO) == ButtonType.YES;
    }

    public static ButtonType confirmYesNoCancel(String title, String message) {
        return FxAlerts.confirm(Alert.AlertType.WARNING, title, message, ButtonType.YES, ButtonType.NO, ButtonType.CANCEL);
    }

    public static ButtonType confirm(Alert.AlertType alertType, String title, String message, ButtonType ... buttonTypes) {
        try {
            Alert alert = new Alert(alertType, message, buttonTypes);
            alert.setTitle(title);
            alert.setHeaderText(null);
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            FxApp.setupIcon(stage);
            FxApp.setupModality(alert);
            Optional result = alert.showAndWait();
            return result.orElse(ButtonType.CANCEL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ButtonType.CANCEL;
        }
    }
}

