/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.javafx;

import com.xwintop.xcore.javafx.helper.LayoutHelper;
import com.xwintop.xcore.util.javafx.JavaFxSystemUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;

public class FxApp {
    public static Stage primaryStage;
    public static Image appIcon;
    public static final List<String> styleSheets;

    public static void init(Stage primaryStage, String iconPath) {
        FxApp.primaryStage = primaryStage;
        JavaFxSystemUtil.mainStage = primaryStage;
        if (StringUtils.isNotBlank((CharSequence)iconPath)) {
            appIcon = LayoutHelper.icon(iconPath);
            primaryStage.getIcons().add((Object)appIcon);
        }
    }

    public static void setupIcon(Stage stage) {
        if (appIcon != null) {
            stage.getIcons().clear();
            stage.getIcons().add((Object)appIcon);
        }
    }

    public static void setupModality(Stage stage) {
        if (stage != null && primaryStage != null && primaryStage.isShowing()) {
            stage.initOwner((Window)primaryStage);
            stage.initModality(Modality.WINDOW_MODAL);
        }
    }

    public static void setupModality(Dialog<?> stage) {
        if (stage != null && primaryStage != null && primaryStage.isShowing()) {
            stage.initOwner((Window)primaryStage);
            stage.initModality(Modality.WINDOW_MODAL);
        }
    }

    public static void runLater(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    static {
        styleSheets = new ArrayList<String>();
    }
}

