/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.recordandplay;

import android.annotation.SuppressLint;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.Timer;
import java.util.TimerTask;

public class PlayerUtil
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener {
    private MediaPlayer mediaPlayer;
    private Timer mTimer;
    private MediaPlayerStatuListener mediaPlayerStatuListener;
    private TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                if (PlayerUtil.this.mediaPlayer == null) {
                    return;
                }
                if (PlayerUtil.this.mediaPlayer.isPlaying()) {
                    PlayerUtil.this.handler.sendEmptyMessage(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)"mediaPlayer==>", (String)("" + e.getMessage()));
            }
        }
    };
    @SuppressLint(value={"HandlerLeak"})
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    int position = PlayerUtil.this.mediaPlayer.getCurrentPosition();
                    int duration = PlayerUtil.this.mediaPlayer.getDuration();
                    if (duration <= 0) break;
                    double pos = (double)position / (double)duration;
                    PlayerUtil.this.mediaPlayerStatuListener.progress(pos);
                    Log.e((String)"PlayerUtil == >", (String)("" + pos));
                    break;
                }
                case 1: {
                    PlayerUtil.this.mediaPlayerStatuListener.currentStatu(PlayerUtil.STATU_CACHING);
                    break;
                }
                case 2: {
                    PlayerUtil.this.mediaPlayerStatuListener.currentStatu(PlayerUtil.STATU_PLAYING);
                }
            }
        }
    };
    public static final String STATU_CACHING = "\u7f13\u5b58\u4e2d";
    public static final String STATU_PLAYING = "\u64ad\u653e\u4e2d";

    public void play() {
        if (null != this.mediaPlayer) {
            this.mediaPlayer.start();
        }
    }

    public void playUrl(String url, MediaPlayerStatuListener mediaPlayerStatuListener) {
        this.mediaPlayerStatuListener = mediaPlayerStatuListener;
        try {
            if (null == this.mediaPlayer) {
                this.mediaPlayer = new MediaPlayer();
            }
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            if (null != this.mTimer) {
                this.mTimer = null;
            }
            this.mTimer = new Timer();
            this.mTimer.schedule(this.timerTask, 0L, 100L);
            this.handler.sendEmptyMessage(1);
            this.mediaPlayer.reset();
            this.mediaPlayer.setDataSource(url);
            this.mediaPlayer.prepare();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"mediaPlayer==>", (String)("" + e.getMessage()));
        }
    }

    public void pause() {
        if (null != this.mediaPlayer) {
            this.mediaPlayer.pause();
        }
        Log.e((String)"mediaPlayer==>", (String)"pause");
    }

    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mTimer.cancel();
            this.mTimer = null;
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
        Log.e((String)"mediaPlayer==>", (String)"stop");
    }

    public void onPrepared(MediaPlayer mp) {
        this.handler.sendEmptyMessage(2);
        mp.start();
        Log.e((String)"mediaPlayer==>", (String)"onPrepared");
    }

    public void onCompletion(MediaPlayer mp) {
        this.mediaPlayerStatuListener.progress(0.0);
        this.mediaPlayerStatuListener.progress2(0L);
        this.mediaPlayerStatuListener.currentStatu("");
        this.stop();
        Log.e((String)"mediaPlayer==>", (String)"onCompletion");
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        if (null != this.mediaPlayer) {
            this.mediaPlayer.reset();
        }
        Log.e((String)"mediaPlayer==>", (String)"onError");
        return false;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.mediaPlayerStatuListener.progress2(percent);
    }

    public static interface MediaPlayerStatuListener {
        public void currentStatu(String var1);

        public void progress(double var1);

        public void progress2(long var1);
    }
}

