/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.recordandplay;

import android.media.MediaPlayer;

public class PlayRecordUtil {
    private static MediaPlayer mPlayer;
    private static boolean isPause;

    public static void playSound(String filePath) {
        if (mPlayer == null) {
            mPlayer = new MediaPlayer();
        } else {
            mPlayer.reset();
        }
        mPlayer.setAudioStreamType(3);
        mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                PlayRecordUtil.release();
            }
        });
        mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                mPlayer.reset();
                return false;
            }
        });
        try {
            mPlayer.setDataSource(filePath);
            mPlayer.prepare();
            mPlayer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            PlayRecordUtil.release();
        }
        isPause = false;
    }

    public static void pause() {
        if (mPlayer != null && mPlayer.isPlaying()) {
            mPlayer.pause();
            isPause = true;
        }
    }

    public static void resume() {
        if (mPlayer != null && isPause) {
            mPlayer.start();
            isPause = false;
        }
    }

    public static void release() {
        if (mPlayer != null) {
            if (mPlayer.isPlaying()) {
                mPlayer.stop();
            }
            mPlayer.release();
            mPlayer = null;
        }
        isPause = false;
    }

    static {
        isPause = false;
    }
}

