/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.mdialogstyle.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.mrlong.mdialogstyle.R;

public class AlertDialog {
    private Context context;
    private TextView title;
    private TextView msg;
    private TextView cancel;
    private ImageView line;
    private TextView sure;
    private Dialog dialog;
    private LinearLayout bg;
    private boolean isShowTitle = false;
    private boolean isShowCancelBtn = false;

    public AlertDialog(Context context) {
        this.context = context;
    }

    public AlertDialog builder() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.dialog_sure, null);
        this.bg = (LinearLayout)view.findViewById(R.id.ll_bg);
        this.title = (TextView)view.findViewById(R.id.tv_title);
        this.msg = (TextView)view.findViewById(R.id.tv_msg);
        this.cancel = (TextView)view.findViewById(R.id.btn_cancel);
        this.line = (ImageView)view.findViewById(R.id.img_line);
        this.sure = (TextView)view.findViewById(R.id.btn_sure);
        this.title.setVisibility(8);
        this.cancel.setVisibility(8);
        this.line.setVisibility(8);
        this.dialog = new Dialog(this.context, R.style.AlertDialogStyle);
        this.dialog.setContentView(view);
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        this.bg.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)((double)display.getWidth() * 0.8), -2));
        return this;
    }

    public void show() {
        this.setLayoutShow();
        this.dialog.show();
    }

    private void setLayoutShow() {
        if (this.isShowCancelBtn) {
            this.cancel.setVisibility(0);
            this.line.setVisibility(0);
        } else {
            this.cancel.setVisibility(8);
            this.line.setVisibility(8);
        }
        if (this.isShowTitle) {
            this.title.setVisibility(0);
        } else {
            this.title.setVisibility(8);
        }
    }

    public AlertDialog setCancelBtn(String cancelStr, final View.OnClickListener listener) {
        this.isShowCancelBtn = true;
        if (null != cancelStr && !"".equals(cancelStr)) {
            this.cancel.setText((CharSequence)cancelStr);
        } else {
            this.cancel.setText((CharSequence)"\u53d6\u6d88");
        }
        this.cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                listener.onClick(view);
                AlertDialog.this.dialog.dismiss();
            }
        });
        return this;
    }

    public AlertDialog setPostBtn(String postStr, final View.OnClickListener listener) {
        if (null != postStr && !"".equals(postStr)) {
            this.sure.setText((CharSequence)postStr);
        } else {
            this.sure.setText((CharSequence)"\u786e\u5b9a");
        }
        this.sure.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                listener.onClick(view);
                AlertDialog.this.dialog.dismiss();
            }
        });
        return this;
    }

    public AlertDialog setCanceledOnTouchOutside(boolean cancel) {
        this.dialog.setCanceledOnTouchOutside(cancel);
        return this;
    }

    public AlertDialog setCancelable(boolean cancel) {
        this.dialog.setCancelable(cancel);
        return this;
    }

    public AlertDialog setMsg(String msgStr) {
        if (null != msgStr && !"".equals(msgStr)) {
            this.msg.setText((CharSequence)msgStr);
        } else {
            this.msg.setText((CharSequence)"\u5185\u5bb9");
        }
        return this;
    }

    public AlertDialog setTitle(String titleStr) {
        this.isShowTitle = true;
        if (null != titleStr && !"".equals(titleStr)) {
            this.title.setText((CharSequence)titleStr);
        } else {
            this.title.setText((CharSequence)"\u6807\u9898");
        }
        return this;
    }
}

