/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.mdialogstyle.dialog;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.Nullable;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import android.widget.TimePicker;
import cn.mrlong.mdialogstyle.R;
import cn.mrlong.mdialogstyle.dialog.TimeUtil;
import java.util.ArrayList;
import java.util.List;

public class AlertDateATimeDialog {
    private Context context;
    private Dialog dialog;
    private Display display;
    private PostClickListener listener;
    private boolean isShowTime = true;
    private boolean isWhite = false;
    private DatePicker datePicker;
    private TimePicker timePicker;
    private String title;
    private TextView title1;
    private String[] delimiter = new String[0];
    private String delimiterStr;
    private long maxData = 0L;
    private long minData = 0L;

    public AlertDateATimeDialog setTitle(String title) {
        this.title = title;
        if (null != title && !"".equals(title)) {
            this.title1.setText((CharSequence)title);
        }
        return this;
    }

    public AlertDateATimeDialog(Context context, boolean isShowTime, boolean isWhite) {
        this.isShowTime = isShowTime;
        this.context = context;
        this.isWhite = isWhite;
    }

    public AlertDateATimeDialog builder() {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        this.display = wm.getDefaultDisplay();
        View view = this.isWhite ? LayoutInflater.from((Context)this.context).inflate(R.layout.dialog_date_time_white, null) : LayoutInflater.from((Context)this.context).inflate(R.layout.dialog_date_time, null);
        TextView cancel = (TextView)view.findViewById(R.id.tv_cancel);
        this.title1 = (TextView)view.findViewById(R.id.tv_title);
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (null != AlertDateATimeDialog.this.dialog) {
                    AlertDateATimeDialog.this.dialog.dismiss();
                }
            }
        });
        TextView sure = (TextView)view.findViewById(R.id.tv_sure);
        this.datePicker = (DatePicker)view.findViewById(R.id.dp_date);
        this.timePicker = (TimePicker)view.findViewById(R.id.dp_time);
        this.timePicker.setIs24HourView(Boolean.valueOf(true));
        this.datePicker.setCalendarViewShown(false);
        this.datePicker.setDescendantFocusability(393216);
        this.timePicker.setDescendantFocusability(393216);
        if (!this.isShowTime) {
            this.timePicker.setVisibility(8);
        } else {
            this.timePicker.setVisibility(0);
        }
        this.resizePikcer((FrameLayout)this.datePicker);
        this.resizePikcer((FrameLayout)this.timePicker);
        view.setMinimumWidth(this.display.getWidth());
        this.dialog = new Dialog(this.context, R.style.ActionSheetDialogStyle);
        this.dialog.setContentView(view);
        Window window = this.dialog.getWindow();
        window.setGravity(83);
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.x = 0;
        lp.y = 0;
        window.setAttributes(lp);
        sure.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String dAt = "";
                String timeStamp = "";
                String year = AlertDateATimeDialog.this.datePicker.getYear() + "";
                String mouth = "";
                mouth = AlertDateATimeDialog.this.datePicker.getMonth() + 1 < 10 ? "0" + (AlertDateATimeDialog.this.datePicker.getMonth() + 1) : AlertDateATimeDialog.this.datePicker.getMonth() + 1 + "";
                String dayOfMonth = "";
                dayOfMonth = AlertDateATimeDialog.this.datePicker.getDayOfMonth() < 10 ? "0" + AlertDateATimeDialog.this.datePicker.getDayOfMonth() : "" + AlertDateATimeDialog.this.datePicker.getDayOfMonth();
                String hour = "";
                hour = AlertDateATimeDialog.this.timePicker.getCurrentHour() < 10 ? "0" + AlertDateATimeDialog.this.timePicker.getCurrentHour() : "" + AlertDateATimeDialog.this.timePicker.getCurrentHour();
                String minute = "";
                minute = AlertDateATimeDialog.this.timePicker.getCurrentMinute() < 10 ? "0" + AlertDateATimeDialog.this.timePicker.getCurrentMinute() : "" + AlertDateATimeDialog.this.timePicker.getCurrentMinute();
                if (AlertDateATimeDialog.this.isShowTime) {
                    timeStamp = TimeUtil.data(year + "\u5e74" + mouth + "\u6708" + dayOfMonth + "\u65e5" + hour + "\u65f6" + minute + "\u520600\u79d2");
                    dAt = AlertDateATimeDialog.this.delimiter.length > 0 ? year + AlertDateATimeDialog.this.delimiter[0] + mouth + AlertDateATimeDialog.this.delimiter[1] + dayOfMonth + AlertDateATimeDialog.this.delimiter[2] + hour + AlertDateATimeDialog.this.delimiter[3] + minute + AlertDateATimeDialog.this.delimiter[4] : (null != AlertDateATimeDialog.this.delimiterStr && !"".equals(AlertDateATimeDialog.this.delimiterStr) && !"".equals(AlertDateATimeDialog.this.delimiterStr) ? year + AlertDateATimeDialog.this.delimiterStr + mouth + AlertDateATimeDialog.this.delimiterStr + dayOfMonth + AlertDateATimeDialog.this.delimiterStr + hour + AlertDateATimeDialog.this.delimiterStr + minute : year + "-" + mouth + "-" + dayOfMonth + " " + hour + ":" + minute);
                } else {
                    dAt = AlertDateATimeDialog.this.delimiter.length > 0 ? year + AlertDateATimeDialog.this.delimiter[0] + mouth + AlertDateATimeDialog.this.delimiter[1] + dayOfMonth + AlertDateATimeDialog.this.delimiter[2] : (null != AlertDateATimeDialog.this.delimiterStr && !"".equals(AlertDateATimeDialog.this.delimiterStr) && !"".equals(AlertDateATimeDialog.this.delimiterStr) ? year + AlertDateATimeDialog.this.delimiterStr + mouth + AlertDateATimeDialog.this.delimiterStr + dayOfMonth : year + "-" + mouth + "-" + dayOfMonth);
                }
                if (null != AlertDateATimeDialog.this.listener) {
                    System.out.println("====>" + timeStamp);
                    AlertDateATimeDialog.this.listener.onClick(dAt, timeStamp);
                }
                AlertDateATimeDialog.this.dialog.dismiss();
            }
        });
        return this;
    }

    private void resizePikcer(FrameLayout tp) {
        List<NumberPicker> npList = this.findNumberPicker((ViewGroup)tp);
        for (NumberPicker np : npList) {
            this.resizeNumberPicker(np);
        }
    }

    public AlertDateATimeDialog setMaxDate(long timeStamp) {
        this.maxData = timeStamp;
        if (this.maxData != 0L) {
            this.datePicker.setMaxDate(this.maxData);
        }
        return this;
    }

    public AlertDateATimeDialog setMinDate(long timeStamp) {
        this.minData = timeStamp;
        if (this.minData != 0L) {
            this.datePicker.setMaxDate(timeStamp);
        }
        return this;
    }

    public AlertDateATimeDialog setDelimiter(String[] delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public AlertDateATimeDialog setDelimiter(String delimiter) {
        this.delimiterStr = delimiter;
        return this;
    }

    public AlertDateATimeDialog setPostClickListener(PostClickListener listener) {
        this.listener = listener;
        return this;
    }

    private void setNumberPickerTextSize(ViewGroup viewGroup) {
        List<NumberPicker> npList = this.findNumberPicker(viewGroup);
        if (null != npList) {
            for (NumberPicker np : npList) {
                EditText et = this.findEditText(np);
                et.setFocusable(false);
                et.setGravity(17);
                et.setTextSize(10.0f);
            }
        }
    }

    private EditText findEditText(NumberPicker np) {
        if (null != np) {
            for (int i = 0; i < np.getChildCount(); ++i) {
                View child = np.getChildAt(i);
                if (!(child instanceof EditText)) continue;
                return (EditText)child;
            }
        }
        return null;
    }

    private void resizeNumberPicker(NumberPicker np) {
        LinearLayout.LayoutParams params = !this.isShowTime ? new LinearLayout.LayoutParams(this.display.getWidth() / 4, -2) : new LinearLayout.LayoutParams(this.display.getWidth() / 7, -2);
        params.setMargins(10, 0, 10, 0);
        np.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private List<NumberPicker> findNumberPicker(ViewGroup viewGroup) {
        ArrayList<NumberPicker> npList = new ArrayList<NumberPicker>();
        View child = null;
        if (null != viewGroup) {
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                List<NumberPicker> result;
                child = viewGroup.getChildAt(i);
                if (child instanceof NumberPicker) {
                    npList.add((NumberPicker)child);
                    continue;
                }
                if (!(child instanceof LinearLayout) || (result = this.findNumberPicker((ViewGroup)child)).size() <= 0) continue;
                return result;
            }
        }
        return npList;
    }

    public void show() {
        this.dialog.show();
    }

    public static interface PostClickListener {
        public void onClick(String var1, @Nullable String var2);
    }
}

