/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

public class SpringBeanUtils {
    public static <T> List<T> getBeans(ApplicationContext applicationContext, Class<T> aClass) {
        Map beansOfTypeMap = applicationContext.getBeansOfType(aClass);
        if (beansOfTypeMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList(beansOfTypeMap.values());
    }

    public static <T> T getObjectByInterfaceClass(Set<Object> sourceObject, Class<T> interfaceClass) {
        if (sourceObject == null || sourceObject.isEmpty()) {
            return null;
        }
        for (Object configSingletonObject : sourceObject) {
            Set allInterfacesForClassAsSet = ClassUtils.getAllInterfacesAsSet((Object)configSingletonObject);
            if (!allInterfacesForClassAsSet.contains(interfaceClass)) continue;
            return (T)configSingletonObject;
        }
        return null;
    }

    public static <T> T getObjectClass(Set<Object> sourceObject, Class<T> aClass) {
        if (sourceObject == null || sourceObject.isEmpty()) {
            return null;
        }
        for (Object configSingletonObject : sourceObject) {
            if (!Objects.equals(configSingletonObject.getClass(), aClass)) continue;
            return (T)configSingletonObject;
        }
        return null;
    }

    public static <T> T getExistBean(ApplicationContext applicationContext, Class<T> aClass) {
        String[] beanNamesForType = applicationContext.getBeanNamesForType(aClass, false, false);
        if (beanNamesForType.length > 0) {
            return (T)applicationContext.getBean(aClass);
        }
        return null;
    }

    public static <T> T getExistBean(ApplicationContext applicationContext, String beanName) {
        if (applicationContext.containsBean(beanName)) {
            Object bean = applicationContext.getBean(beanName);
            return (T)bean;
        }
        return null;
    }
}

