/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.utils.CommonUtils;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceUtils.class);
    public static final String TYPE_FILE = "file";
    public static final String TYPE_CLASSPATH = "classpath";
    public static final String TYPE_PACKAGE = "package";
    public static final String ROOT_PLUGIN_SIGN = "~";
    public static final String TYPE_SPLIT = ":";

    public static String getMatchLocation(String locationMatch) {
        if (StringUtils.isNullOrEmpty((String)locationMatch)) {
            return null;
        }
        String classPathType = "classpath:";
        if (ResourceUtils.isClasspath(locationMatch)) {
            return locationMatch.replaceFirst(classPathType, "");
        }
        String fileType = "file:";
        if (ResourceUtils.isFile(locationMatch)) {
            return locationMatch.replaceFirst(fileType, "");
        }
        String packageType = "package:";
        if (ResourceUtils.isPackage(locationMatch)) {
            String location = locationMatch.replaceFirst(packageType, "");
            return location.replace(".", "/");
        }
        LOGGER.error("locationMatch {} illegal", (Object)locationMatch);
        return null;
    }

    public static boolean isClasspath(String locationMatch) {
        return locationMatch.startsWith("classpath:");
    }

    public static boolean isFile(String locationMatch) {
        return locationMatch.startsWith("file:");
    }

    public static boolean isPackage(String locationMatch) {
        return locationMatch.startsWith("package:");
    }

    public static String getAbsolutePath(PluginRegistryInfo pluginRegistryInfo, String rootDir) {
        if (StringUtils.isNullOrEmpty((String)rootDir)) {
            return rootDir;
        }
        String home = null;
        if (rootDir.startsWith(ROOT_PLUGIN_SIGN)) {
            PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
            RuntimeMode runtimeMode = pluginWrapper.getRuntimeMode();
            String pluginRootDir = runtimeMode == RuntimeMode.DEVELOPMENT ? pluginWrapper.getPluginPath().toString() : System.getProperty("user.dir");
            home = rootDir.replaceFirst("\\~", "");
            home = CommonUtils.joiningFilePath(pluginRootDir, home);
        } else {
            home = rootDir;
        }
        return home;
    }
}

