/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.realize;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.integration.operator.module.PluginInfo;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class ConfigDefinitionTip {
    private final PluginRegistryInfo pluginRegistryInfo;

    public ConfigDefinitionTip(PluginRegistryInfo pluginRegistryInfo) {
        this.pluginRegistryInfo = pluginRegistryInfo;
    }

    public PluginInfo getCurrentPluginInfo() {
        PluginWrapper pluginWrapper = this.pluginRegistryInfo.getPluginWrapper();
        PluginManager pluginManager = pluginWrapper.getPluginManager();
        return new PluginInfo(pluginWrapper.getDescriptor(), pluginWrapper.getPluginState(), pluginWrapper.getPluginPath().toAbsolutePath().toString(), pluginManager.getRuntimeMode().toString());
    }

    public ApplicationContext getMainApplication() {
        return this.pluginRegistryInfo.getMainApplicationContext();
    }

    public <T> T getOtherConfigDefinition(Class<T> configDefinitionClass) {
        return SpringBeanUtils.getObjectClass(this.pluginRegistryInfo.getConfigSingletons(), configDefinitionClass);
    }

    public <T> T getConfigOfBean(String prefix, Class<T> type) {
        return (T)this.pluginRegistryInfo.getPluginBinder().bind(prefix, Bindable.of(type)).orElseGet(() -> null);
    }

    public <T> List<T> getConfigOfList(String prefix, Class<T> type) {
        return (List)this.pluginRegistryInfo.getPluginBinder().bind(prefix, Bindable.listOf(type)).orElseGet(Collections::emptyList);
    }

    public <T> Set<T> getConfigOfSet(String prefix, Class<T> type) {
        return (Set)this.pluginRegistryInfo.getPluginBinder().bind(prefix, Bindable.setOf(type)).orElseGet(Collections::emptySet);
    }

    public <K, V> Map<K, V> getConfigOfSet(String prefix, Class<K> keyType, Class<V> valueType) {
        return (Map)this.pluginRegistryInfo.getPluginBinder().bind(prefix, Bindable.mapOf(keyType, valueType)).orElseGet(Collections::emptyMap);
    }

    public ConfigurableEnvironment getPluginEnvironment() {
        return this.pluginRegistryInfo.getPluginApplicationContext().getEnvironment();
    }

    public Binder getPluginBinder() {
        return this.pluginRegistryInfo.getPluginBinder();
    }
}

