/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.user;

import com.gitee.starblues.factory.process.pipe.PluginInfoContainers;
import com.gitee.starblues.integration.user.PluginUser;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ObjectUtils;

public class DefaultPluginUser
implements PluginUser {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final GenericApplicationContext parentApplicationContext;
    protected final PluginManager pluginManager;

    public DefaultPluginUser(ApplicationContext parentApplicationContext, PluginManager pluginManager) {
        Objects.requireNonNull(parentApplicationContext, "ApplicationContext can't be null");
        Objects.requireNonNull(pluginManager, "PluginManager can't be null");
        this.parentApplicationContext = (GenericApplicationContext)parentApplicationContext;
        this.pluginManager = pluginManager;
    }

    @Override
    public <T> T getBean(String name) {
        return this.getBean(name, true);
    }

    @Override
    public <T> T getBean(Class<T> aClass) {
        return this.getBean(aClass, true);
    }

    @Override
    public <T> T getPluginBean(String name) {
        return this.getBean(name, false);
    }

    @Override
    public <T> List<T> getBeans(Class<T> aClass) {
        return this.getBeans(aClass, 3);
    }

    @Override
    public <T> List<T> getMainBeans(Class<T> aClass) {
        return this.getBeans(aClass, 1);
    }

    @Override
    public <T> List<T> getPluginBeans(Class<T> aClass) {
        return this.getBeans(aClass, 2);
    }

    @Override
    public <T> List<T> getPluginBeans(String pluginId, Class<T> aClass) {
        GenericApplicationContext pluginApplicationContext = PluginInfoContainers.getPluginApplicationContext(pluginId);
        if (pluginApplicationContext == null) {
            return Collections.emptyList();
        }
        return SpringBeanUtils.getBeans((ApplicationContext)pluginApplicationContext, aClass);
    }

    @Override
    public List<Object> getPluginBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        List<GenericApplicationContext> pluginApplicationContexts = PluginInfoContainers.getPluginApplicationContexts();
        ArrayList<Object> beans = new ArrayList<Object>();
        for (GenericApplicationContext pluginApplicationContext : pluginApplicationContexts) {
            Map beanMap = pluginApplicationContext.getBeansWithAnnotation(annotationType);
            if (ObjectUtils.isEmpty((Object)beanMap)) continue;
            beans.addAll(beanMap.values());
        }
        return beans;
    }

    @Override
    public List<Object> getPluginBeansWithAnnotation(String pluginId, Class<? extends Annotation> annotationType) {
        GenericApplicationContext genericApplicationContext = PluginInfoContainers.getPluginApplicationContext(pluginId);
        if (genericApplicationContext == null) {
            return Collections.emptyList();
        }
        Map beanMap = genericApplicationContext.getBeansWithAnnotation(annotationType);
        if (!ObjectUtils.isEmpty((Object)beanMap)) {
            return new ArrayList<Object>(beanMap.values());
        }
        return Collections.emptyList();
    }

    @Override
    public <T> T generateNewInstance(T object) {
        if (object == null) {
            return null;
        }
        List<GenericApplicationContext> pluginApplicationContexts = PluginInfoContainers.getPluginApplicationContexts();
        pluginApplicationContexts.add(this.parentApplicationContext);
        Class<?> aClass = object.getClass();
        for (GenericApplicationContext pluginApplicationContext : pluginApplicationContexts) {
            try {
                pluginApplicationContext.getBean(aClass);
                Object newBean = pluginApplicationContext.getBeanFactory().createBean(aClass);
                return (T)newBean;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public <T> List<T> getPluginExtensions(Class<T> tClass) {
        return this.pluginManager.getExtensions(tClass);
    }

    private <T> T getBean(String name, boolean haveParent) {
        List<GenericApplicationContext> pluginApplicationContexts = PluginInfoContainers.getPluginApplicationContexts();
        if (haveParent) {
            pluginApplicationContexts.add(this.parentApplicationContext);
        }
        for (GenericApplicationContext pluginApplicationContext : pluginApplicationContexts) {
            if (!pluginApplicationContext.containsBean(name)) continue;
            return (T)pluginApplicationContext.getBean(name);
        }
        return null;
    }

    private <T> T getBean(Class<T> aClass, boolean haveParent) {
        List<GenericApplicationContext> pluginApplicationContexts = PluginInfoContainers.getPluginApplicationContexts();
        if (haveParent) {
            pluginApplicationContexts.add(this.parentApplicationContext);
        }
        for (GenericApplicationContext pluginApplicationContext : pluginApplicationContexts) {
            try {
                Object bean = pluginApplicationContext.getBean(aClass);
                if (bean == null) continue;
                return (T)bean;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private <T> List<T> getBeans(Class<T> aClass, int type) {
        ArrayList<GenericApplicationContext> pluginApplicationContexts = new ArrayList<GenericApplicationContext>(1);
        if (type == 1) {
            pluginApplicationContexts.add(this.parentApplicationContext);
        } else if (type == 2) {
            pluginApplicationContexts.addAll(PluginInfoContainers.getPluginApplicationContexts());
        } else if (type == 3) {
            pluginApplicationContexts.add(this.parentApplicationContext);
            pluginApplicationContexts.addAll(PluginInfoContainers.getPluginApplicationContexts());
        } else {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (GenericApplicationContext pluginApplicationContext : pluginApplicationContexts) {
            List<T> pluginBeans = SpringBeanUtils.getBeans((ApplicationContext)pluginApplicationContext, aClass);
            if (pluginBeans.isEmpty()) continue;
            result.addAll(pluginBeans);
        }
        return result;
    }
}

