/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.pf4j.descriptor;

import com.gitee.starblues.integration.pf4j.descriptor.DefaultPluginDescriptorExtend;
import com.gitee.starblues.integration.pf4j.descriptor.ResolvePropertiesPluginDescriptorFinder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.pf4j.DefaultPluginDescriptor;
import org.pf4j.PluginDescriptor;
import org.pf4j.PropertiesPluginDescriptorFinder;
import org.pf4j.RuntimeMode;
import org.pf4j.util.StringUtils;

public class ResourcesPluginDescriptorFinder
extends PropertiesPluginDescriptorFinder {
    public static final String PLUGIN_CONFIG_FILE_NAME = "plugin.configFileName";
    public static final String PLUGIN_CONFIG_FILE_PROFILE = "plugin.configFileProfile";
    private final RuntimeMode runtimeMode;

    public ResourcesPluginDescriptorFinder(RuntimeMode runtimeMode) {
        this.runtimeMode = runtimeMode;
    }

    public boolean isApplicable(Path pluginPath) {
        Path propFilePath = this.getPropFilePath(pluginPath);
        return super.isApplicable(propFilePath);
    }

    public PluginDescriptor find(Path pluginPath) {
        Path propFilePath = this.getPropFilePath(pluginPath);
        return super.find(propFilePath);
    }

    protected Properties readProperties(Path pluginPath) {
        Path propertiesPath = this.getPropertiesPath(pluginPath, this.propertiesFileName);
        return ResolvePropertiesPluginDescriptorFinder.getProperties(propertiesPath);
    }

    protected PluginDescriptor createPluginDescriptor(Properties properties) {
        DefaultPluginDescriptorExtend pluginDescriptor = (DefaultPluginDescriptorExtend)super.createPluginDescriptor(properties);
        return ResourcesPluginDescriptorFinder.resolvePluginDescriptor(properties, pluginDescriptor);
    }

    static PluginDescriptor resolvePluginDescriptor(Properties properties, DefaultPluginDescriptorExtend pluginDescriptor) {
        String configFileProfile;
        String configFileName = properties.getProperty(PLUGIN_CONFIG_FILE_NAME);
        if (!StringUtils.isNullOrEmpty((String)configFileName)) {
            pluginDescriptor.setConfigFileName(configFileName);
        }
        if (!StringUtils.isNullOrEmpty((String)(configFileProfile = properties.getProperty(PLUGIN_CONFIG_FILE_PROFILE)))) {
            pluginDescriptor.setConfigFileProfile(configFileProfile);
        }
        return pluginDescriptor;
    }

    protected DefaultPluginDescriptor createPluginDescriptorInstance() {
        return new DefaultPluginDescriptorExtend();
    }

    private Path getPropFilePath(Path pluginPath) {
        if (this.runtimeMode == RuntimeMode.DEPLOYMENT) {
            return pluginPath;
        }
        return Paths.get(pluginPath.toString(), "src", "main", "resources");
    }
}

