/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.listener;

import com.gitee.starblues.integration.listener.PluginListener;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class PluginListenerFactory
implements PluginListener {
    private final List<PluginListener> listeners = new ArrayList<PluginListener>();
    private final List<Class> listenerClasses = new ArrayList<Class>();
    private boolean isBuildListenerClass = false;

    @Override
    public void registry(String pluginId, boolean isInitialize) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.registry(pluginId, isInitialize);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void unRegistry(String pluginId) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.unRegistry(pluginId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void registryFailure(String pluginId, Throwable throwable) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.registryFailure(pluginId, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void unRegistryFailure(String pluginId, Throwable throwable) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.unRegistryFailure(pluginId, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addPluginListener(PluginListener pluginListener) {
        if (pluginListener != null) {
            this.listeners.add(pluginListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginListener> void addPluginListener(Class<T> pluginListenerClass) {
        if (pluginListenerClass != null) {
            List<Class> list = this.listenerClasses;
            synchronized (list) {
                this.listenerClasses.add(pluginListenerClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginListener> void buildListenerClass(GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        List<Class> list = this.listenerClasses;
        synchronized (list) {
            if (this.isBuildListenerClass) {
                return;
            }
            List<PluginListener> pluginListeners = SpringBeanUtils.getBeans((ApplicationContext)applicationContext, PluginListener.class);
            if (pluginListeners.isEmpty()) {
                pluginListeners = new ArrayList<PluginListener>();
            }
            for (Class listenerClass : this.listenerClasses) {
                applicationContext.registerBeanDefinition(listenerClass.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition((Class)listenerClass).getBeanDefinition());
                PluginListener bean = (PluginListener)applicationContext.getBean(listenerClass);
                pluginListeners.add(bean);
            }
            for (PluginListener pluginListener : pluginListeners) {
                boolean find = false;
                for (PluginListener listener : this.listeners) {
                    if (!Objects.equals(listener, pluginListener)) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                this.listeners.add(pluginListener);
            }
            this.listenerClasses.clear();
            this.isBuildListenerClass = true;
        }
    }

    public List<PluginListener> getListeners() {
        return this.listeners;
    }

    public List<Class> getListenerClasses() {
        return this.listenerClasses;
    }
}

