/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.realize.ConfigBean;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PluginConfigBeanPipeProcessor
implements PluginPipeProcessor {
    private static final String KEY = "ConfigBeans";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        List<ConfigBean> pluginBeans = SpringBeanUtils.getBeans((ApplicationContext)pluginRegistryInfo.getPluginApplicationContext(), ConfigBean.class);
        if (pluginBeans.isEmpty()) {
            return;
        }
        ArrayList<ConfigBean> successConfigBeans = new ArrayList<ConfigBean>(pluginBeans.size());
        for (ConfigBean pluginBean : pluginBeans) {
            try {
                pluginBean.initialize();
                successConfigBeans.add(pluginBean);
            }
            catch (Exception e) {
                this.logger.error("Plugin '{}' configBean '{}' initialize exception.", new Object[]{pluginRegistryInfo.getPluginWrapper().getPluginId(), pluginBean.getClass().getName(), e});
            }
        }
        pluginRegistryInfo.addExtension(KEY, successConfigBeans);
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        List pluginBeans = (List)pluginRegistryInfo.getExtension(KEY);
        if (pluginBeans == null || pluginBeans.isEmpty()) {
            return;
        }
        for (ConfigBean pluginBean : pluginBeans) {
            try {
                pluginBean.destroy();
            }
            catch (Exception e) {
                this.logger.error("Plugin '{}' configBean '{}' destroy exception.", new Object[]{pluginRegistryInfo.getPluginWrapper().getPluginId(), pluginBean.getClass().getName(), e});
            }
        }
    }
}

