/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.support;

import com.gitee.starblues.extension.PluginControllerProcessorExtend;
import com.gitee.starblues.factory.process.post.bean.model.ControllerWrapper;
import com.gitee.starblues.utils.ClassUtils;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.List;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.OpenAPIService;
import org.springframework.context.ApplicationContext;

public class SpringDocControllerProcessor
implements PluginControllerProcessorExtend {
    private final ApplicationContext applicationContext;
    private List<Class<?>> restControllers;
    private OpenAPIService openAPIService;

    public SpringDocControllerProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() {
        AbstractOpenApiResource openApiResource = SpringBeanUtils.getExistBean(this.applicationContext, AbstractOpenApiResource.class);
        if (openApiResource == null) {
            return;
        }
        try {
            this.restControllers = (List)ClassUtils.getReflectionField(openApiResource, "ADDITIONAL_REST_CONTROLLERS");
        }
        catch (IllegalAccessException e) {
            this.restControllers = null;
        }
        this.openAPIService = SpringBeanUtils.getExistBean(this.applicationContext, OpenAPIService.class);
    }

    @Override
    public void registry(String pluginId, List<ControllerWrapper> controllerWrappers) throws Exception {
        if (this.restControllers != null) {
            for (ControllerWrapper controllerWrapper : controllerWrappers) {
                this.restControllers.add(controllerWrapper.getBeanClass());
            }
            this.refresh();
        }
    }

    @Override
    public void unRegistry(String pluginId, List<ControllerWrapper> controllerWrappers) throws Exception {
        if (this.restControllers != null && !this.restControllers.isEmpty()) {
            for (ControllerWrapper controllerWrapper : controllerWrappers) {
                this.restControllers.remove(controllerWrapper.getBeanClass());
            }
            this.refresh();
        }
    }

    private void refresh() {
        if (this.openAPIService != null) {
            this.openAPIService.setCachedOpenAPI(null);
            this.openAPIService.resetCalculatedOpenAPI();
        }
    }
}

