/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.refresh;

import com.gitee.starblues.integration.application.PluginApplication;
import com.gitee.starblues.integration.listener.PluginListener;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public abstract class AbstractSpringBeanRefresh<T>
implements PluginListener {
    private List<T> beans;
    protected final Class<T> typeClass;
    protected final PluginApplication pluginApplication;

    public AbstractSpringBeanRefresh(PluginApplication pluginApplication) {
        this.pluginApplication = pluginApplication;
        pluginApplication.addListener(this);
        this.typeClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public void registry(String pluginId) {
        this.beans = this.refresh();
        this.registryEvent(this.beans);
    }

    @Override
    public void unRegistry(String pluginId) {
        this.beans = this.refresh();
        this.unRegistryEvent(this.beans);
    }

    @Override
    public void failure(String pluginId, Throwable throwable) {
    }

    protected void registryEvent(List<T> beans) {
    }

    protected void unRegistryEvent(List<T> beans) {
    }

    protected List<T> refresh() {
        return this.pluginApplication.getPluginUser().getBeans(this.typeClass);
    }

    public List<T> getBeans() {
        return this.beans;
    }
}

