/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.operator;

import com.gitee.starblues.factory.DefaultPluginFactory;
import com.gitee.starblues.factory.PluginFactory;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.listener.PluginInitializerListener;
import com.gitee.starblues.integration.listener.PluginInitializerListenerFactory;
import com.gitee.starblues.integration.listener.PluginListenerFactory;
import com.gitee.starblues.integration.operator.PluginOperator;
import com.gitee.starblues.integration.operator.module.PluginInfo;
import com.gitee.starblues.integration.operator.verify.PluginLegalVerify;
import com.gitee.starblues.integration.operator.verify.PluginUploadVerify;
import com.gitee.starblues.utils.GlobalRegistryInfo;
import com.gitee.starblues.utils.PluginFileUtils;
import com.gitee.starblues.utils.PluginOperatorInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class DefaultPluginOperator
implements PluginOperator {
    private boolean isInit = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    protected final IntegrationConfiguration integrationConfiguration;
    protected final PluginManager pluginManager;
    protected final PluginFactory pluginFactory;
    protected final PluginInitializerListenerFactory pluginInitializerListenerFactory;
    protected final PluginDescriptorFinder pluginDescriptorFinder;
    protected final PluginLegalVerify uploadPluginVerify;

    public DefaultPluginOperator(ApplicationContext applicationContext, IntegrationConfiguration integrationConfiguration, PluginManager pluginManager, PluginListenerFactory pluginListenerFactory) {
        Objects.requireNonNull(integrationConfiguration, "IntegrationConfiguration can't be null");
        Objects.requireNonNull(pluginManager, "PluginManager can't be null");
        this.integrationConfiguration = integrationConfiguration;
        this.pluginManager = pluginManager;
        this.pluginFactory = new DefaultPluginFactory(applicationContext, pluginListenerFactory);
        this.pluginInitializerListenerFactory = new PluginInitializerListenerFactory(applicationContext);
        this.pluginDescriptorFinder = new ManifestPluginDescriptorFinder();
        this.uploadPluginVerify = new PluginUploadVerify(this.pluginDescriptorFinder, pluginManager);
    }

    @Override
    public synchronized boolean initPlugins(PluginInitializerListener pluginInitializerListener) throws Exception {
        if (this.isInit) {
            throw new RuntimeException("Plugins Already initialized. Cannot be initialized again");
        }
        try {
            PluginFileUtils.cleanEmptyFile(this.pluginManager.getPluginsRoot());
            this.pluginInitializerListenerFactory.addPluginInitializerListeners(pluginInitializerListener);
            this.log.info("Plugins start initialize of root path '{}'", (Object)this.pluginManager.getPluginsRoot().toString());
            this.pluginInitializerListenerFactory.before();
            this.pluginFactory.initialize();
            this.pluginManager.loadPlugins();
            this.pluginManager.startPlugins();
            List pluginWrappers = this.pluginManager.getStartedPlugins();
            if (pluginWrappers == null || pluginWrappers.isEmpty()) {
                this.log.warn("Not found plugin!");
                return false;
            }
            boolean isFoundException = false;
            for (PluginWrapper pluginWrapper : pluginWrappers) {
                String pluginId = pluginWrapper.getPluginId();
                GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.INSTALL, false);
                try {
                    this.pluginFactory.registry(pluginWrapper);
                }
                catch (Exception e) {
                    this.log.error("Plugin '{}' registry failure. Reason : {}", new Object[]{pluginId, e.getMessage(), e});
                    isFoundException = true;
                }
            }
            this.pluginFactory.build();
            if (isFoundException) {
                this.log.error("Plugins initialize failure");
                return false;
            }
            this.log.info("Plugins initialize success");
            this.pluginInitializerListenerFactory.complete();
            this.isInit = true;
            return true;
        }
        catch (Exception e) {
            this.pluginInitializerListenerFactory.failure(e);
            throw e;
        }
    }

    @Override
    public boolean install(Path path) throws Exception {
        boolean sourceFile222;
        block19: {
            String pluginId;
            block17: {
                boolean sourceFile222;
                block18: {
                    block15: {
                        boolean sourceFile222;
                        block16: {
                            if (path == null) {
                                throw new IllegalArgumentException("Method:install param 'pluginId' can not be empty");
                            }
                            pluginId = null;
                            if (!Files.exists(path, new LinkOption[0])) {
                                throw new FileNotFoundException("Not found this path " + path);
                            }
                            this.uploadPluginVerify.verify(path);
                            Path pluginsRoot = this.pluginManager.getPluginsRoot();
                            if (path.getParent().compareTo(pluginsRoot) == 0) {
                                pluginId = this.pluginManager.loadPlugin(path);
                            } else {
                                File sourceFile222 = path.toFile();
                                String targetPathString = pluginsRoot.toString() + File.separator + sourceFile222.getName();
                                Path targetPath = Paths.get(targetPathString, new String[0]);
                                if (Files.exists(targetPath, new LinkOption[0])) {
                                    this.backup(targetPath, "install-backup", 1);
                                }
                                Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                                pluginId = this.pluginManager.loadPlugin(targetPath);
                            }
                            if (!StringUtils.isEmpty((Object)pluginId)) break block15;
                            this.log.error("Plugin '{}' install failure, this plugin id is empty.", (Object)pluginId);
                            sourceFile222 = false;
                            if (pluginId == null) break block16;
                            GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
                        }
                        return sourceFile222;
                    }
                    GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.INSTALL, true);
                    if (!this.start(pluginId)) break block17;
                    this.log.info("Plugin '{}' install success", (Object)pluginId);
                    sourceFile222 = true;
                    if (pluginId == null) break block18;
                    GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
                }
                return sourceFile222;
            }
            try {
                this.log.error("Plugin '{}' install failure", (Object)pluginId);
                sourceFile222 = false;
                if (pluginId == null) break block19;
            }
            catch (Exception e) {
                try {
                    this.log.error("Plugin '{}' install failure. {}", pluginId, (Object)e.getMessage());
                    this.log.info("Start uninstall plugin '{}' failure", pluginId);
                    try {
                        if (!StringUtils.isEmpty(pluginId)) {
                            this.uninstall(pluginId, false);
                        }
                    }
                    catch (Exception uninstallException) {
                        this.log.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)e.getMessage());
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (pluginId != null) {
                        GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
                    }
                    throw throwable;
                }
            }
            GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
        }
        return sourceFile222;
    }

    @Override
    public boolean uninstall(String pluginId, boolean isBackup) throws Exception {
        if (StringUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:uninstall param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new Exception("Plugin uninstall failure, Not found plugin '" + pluginId + "'");
        }
        Exception exception = null;
        try {
            this.pluginFactory.unRegistry(pluginId);
            this.pluginFactory.build();
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' uninstall failure, {}", (Object)pluginId, (Object)e.getMessage());
            exception = e;
        }
        try {
            if (this.pluginManager.unloadPlugin(pluginId)) {
                Path pluginPath = pluginWrapper.getPluginPath();
                if (isBackup) {
                    this.backup(pluginPath, "uninstall", 1);
                } else {
                    Files.deleteIfExists(pluginPath);
                }
                this.log.info("Plugin '{}' uninstall success", (Object)pluginId);
                return true;
            }
            this.log.error("Plugin '{}' uninstall failure", (Object)pluginId);
            return false;
        }
        catch (Exception e) {
            if (exception != null) {
                exception.printStackTrace();
            }
            this.log.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean start(String pluginId) throws Exception {
        if (StringUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:start param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.getPluginWrapper(pluginId, "Start");
        if (pluginWrapper.getPluginState() == PluginState.STARTED) {
            throw new Exception("This plugin '" + pluginId + "' have already started");
        }
        try {
            PluginState pluginState = this.pluginManager.startPlugin(pluginId);
            if (pluginState == PluginState.STARTED) {
                GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.START, false);
                this.pluginFactory.registry(pluginWrapper);
                this.pluginFactory.build();
                this.log.info("Plugin '{}' start success", (Object)pluginId);
                return true;
            }
            this.log.error("Plugin '{}' start failure, plugin state is not start. Current plugin state is '{}'", (Object)pluginId, (Object)pluginState.toString());
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' start failure. {}", (Object)pluginId, (Object)e.getMessage());
            this.log.info("Start stop plugin {}", (Object)pluginId);
            try {
                this.stop(pluginId);
            }
            catch (Exception stopException) {
                this.log.error("Plugin '{}' stop failure. {}", (Object)pluginId, (Object)e.getMessage());
            }
            throw e;
        }
        return false;
    }

    @Override
    public boolean stop(String pluginId) throws Exception {
        if (StringUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:stop param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.getPluginWrapper(pluginId, "Stop");
        if (pluginWrapper.getPluginState() != PluginState.STARTED) {
            throw new Exception("This plugin '" + pluginId + "' is not started");
        }
        try {
            this.pluginFactory.unRegistry(pluginId);
            this.pluginFactory.build();
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' stop failure. {}", (Object)pluginId, (Object)e.getMessage());
            e.printStackTrace();
        }
        try {
            this.pluginManager.stopPlugin(pluginId);
            this.log.info("Plugin '{}' stop success", (Object)pluginId);
            return true;
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' stop failure. {}", (Object)pluginId, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean uploadPluginAndStart(MultipartFile pluginFile) throws Exception {
        if (pluginFile == null) {
            throw new IllegalArgumentException("Method:uploadPluginAndStart param 'pluginFile' can not be null");
        }
        Path path = this.uploadPlugin(pluginFile);
        if (this.install(path)) {
            this.log.info("Plugin upload and start success");
            return true;
        }
        this.log.error("Plugin upload and start failure");
        return false;
    }

    @Override
    public boolean installConfigFile(Path path) throws Exception {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("path ' " + path + "'  does not exist!");
        }
        File sourceFile = path.toFile();
        String configPath = this.integrationConfiguration.pluginConfigFilePath() + File.separator + sourceFile.getName();
        Path targetPath = PluginFileUtils.createExistFile(Paths.get(configPath, new String[0]));
        if (Files.exists(targetPath, new LinkOption[0])) {
            this.backup(targetPath, "install-config-backup", 1);
        }
        Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    @Override
    public boolean uploadConfigFile(MultipartFile configFile) throws Exception {
        if (configFile == null) {
            throw new IllegalArgumentException("Method:uploadConfigFile param 'configFile' can not be null");
        }
        String fileName = configFile.getOriginalFilename();
        String configPath = this.integrationConfiguration.pluginConfigFilePath() + File.separator + fileName;
        Path targetPath = PluginFileUtils.createExistFile(Paths.get(configPath, new String[0]));
        if (Files.exists(targetPath, new LinkOption[0])) {
            this.backup(targetPath, "upload-config-backup", 2);
        }
        Files.write(targetPath, configFile.getBytes(), new OpenOption[0]);
        return true;
    }

    @Override
    public boolean backupPlugin(Path path, String sign) throws Exception {
        Objects.requireNonNull(path);
        return this.backup(path, sign, 2);
    }

    @Override
    public boolean backupPlugin(String pluginId, String sign) throws Exception {
        PluginWrapper pluginManager = this.getPluginWrapper(pluginId, "BackupPlugin by pluginId");
        return this.backupPlugin(pluginManager.getPluginPath(), sign);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        List startedPlugins = this.pluginManager.getPlugins();
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        if (startedPlugins == null) {
            return pluginInfos;
        }
        return startedPlugins.stream().filter(pluginWrapper -> pluginWrapper != null).map(pw -> new PluginInfo(pw.getDescriptor(), pw.getPluginState(), pw.getPluginPath().toAbsolutePath().toString())).collect(Collectors.toList());
    }

    @Override
    public PluginInfo getPluginInfo(String pluginId) {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new RuntimeException("Not found plugin '" + pluginId + "'");
        }
        return new PluginInfo(pluginWrapper.getDescriptor(), pluginWrapper.getPluginState(), pluginWrapper.getPluginPath().toAbsolutePath().toString());
    }

    @Override
    public Set<String> getPluginFilePaths() throws Exception {
        RuntimeMode environment = this.integrationConfiguration.environment();
        HashSet<String> paths = new HashSet<String>();
        if (environment == RuntimeMode.DEVELOPMENT) {
            paths.add(this.integrationConfiguration.pluginPath());
            return paths;
        }
        List files = FileUtils.getJars((Path)Paths.get(this.integrationConfiguration.pluginPath(), new String[0]));
        return files.stream().filter(file -> file != null).map(file -> file.getAbsolutePath()).collect(Collectors.toSet());
    }

    @Override
    public List<PluginWrapper> getPluginWrapper() {
        return this.pluginManager.getPlugins();
    }

    @Override
    public PluginWrapper getPluginWrapper(String pluginId) {
        return this.pluginManager.getPlugin(pluginId);
    }

    private Path uploadPlugin(MultipartFile pluginFile) throws Exception {
        if (pluginFile == null) {
            throw new IllegalArgumentException("Method:uploadPlugin param 'pluginFile' can not be null");
        }
        String fileName = pluginFile.getOriginalFilename();
        String suffixName = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (StringUtils.isEmpty((Object)suffixName)) {
            throw new IllegalArgumentException("Invalid file type, please select .jar or .zip file");
        }
        if (!"jar".equalsIgnoreCase(suffixName) && !"zip".equalsIgnoreCase(suffixName)) {
            throw new IllegalArgumentException("Invalid file type, please select .jar or .zip file");
        }
        String tempPathString = this.integrationConfiguration.uploadTempPath() + File.separator + fileName;
        Path tempPath = PluginFileUtils.createExistFile(Paths.get(tempPathString, new String[0]));
        Files.write(tempPath, pluginFile.getBytes(), new OpenOption[0]);
        try {
            Path verifyPath = this.uploadPluginVerify.verify(tempPath);
            if (verifyPath != null) {
                String targetPathString = this.pluginManager.getPluginsRoot().toString() + File.separator + fileName;
                Path targetPluginPath = Paths.get(targetPathString, new String[0]);
                if (Files.exists(targetPluginPath, new LinkOption[0])) {
                    this.backup(targetPluginPath, "upload", 2);
                }
                Files.copy(verifyPath, targetPluginPath, StandardCopyOption.REPLACE_EXISTING);
                Files.deleteIfExists(tempPath);
                return targetPluginPath;
            }
            Exception exception = new Exception(fileName + " verify failure, verifyPath is null");
            this.verifyFailureDelete(tempPath, exception);
            throw exception;
        }
        catch (Exception e) {
            this.verifyFailureDelete(tempPath, e);
            throw e;
        }
    }

    private PluginWrapper getPluginWrapper(String pluginId, String errorMsg) throws Exception {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new Exception(errorMsg + " -> Not found plugin " + pluginId);
        }
        return pluginWrapper;
    }

    private void verifyFailureDelete(Path tempPluginFile, Exception e) throws Exception {
        try {
            Files.deleteIfExists(tempPluginFile);
        }
        catch (IOException e1) {
            throw new Exception("Verify failure and delete temp file failure : " + e.getMessage(), e);
        }
    }

    private boolean backup(Path sourcePath, String sign, int type) {
        try {
            File sourceFile;
            Path target;
            if (this.isDev()) {
                return false;
            }
            if (sourcePath == null) {
                return false;
            }
            if (!Files.exists(sourcePath, new LinkOption[0])) {
                this.log.error("Path '{}' does not exist", (Object)sourcePath.toString());
                return false;
            }
            String fileName = sourcePath.getFileName().toString();
            String targetName = this.integrationConfiguration.backupPath() + File.separator;
            if (!StringUtils.isEmpty((Object)sign)) {
                targetName = targetName + "[" + sign + "]";
            }
            if (!Files.exists((target = Paths.get((targetName = targetName + "[" + this.getNowTimeByFormat() + "]") + "_" + fileName, new String[0])).getParent(), new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            if ((sourceFile = sourcePath.toFile()).length() == 0L) {
                return true;
            }
            if (type == 1) {
                Files.move(sourcePath, target, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(sourcePath, target, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (IOException e) {
            this.log.error("Backup plugin jar '{}' failure. {}", new Object[]{sourcePath.toString(), e.getMessage(), e});
            return false;
        }
    }

    private String getNowTimeByFormat() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return FORMAT.format(localDateTime);
    }

    private boolean isDev() {
        return this.integrationConfiguration.environment() == RuntimeMode.DEVELOPMENT;
    }
}

