/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.bean.configuration;

import com.gitee.starblues.factory.process.pipe.bean.configuration.ConfigurationParser;
import com.gitee.starblues.factory.process.pipe.bean.configuration.PluginConfigDefinition;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.loader.ResourceWrapper;
import com.gitee.starblues.loader.load.PluginConfigFileLoader;
import com.gitee.starblues.realize.BasePlugin;
import java.util.List;
import java.util.Objects;
import org.springframework.core.io.Resource;

public abstract class AbstractConfigurationParser
implements ConfigurationParser {
    private final IntegrationConfiguration configuration;

    public AbstractConfigurationParser(IntegrationConfiguration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
    }

    @Override
    public Object parse(BasePlugin basePlugin, PluginConfigDefinition pluginConfigDefinition) throws Exception {
        Class<?> configClass = pluginConfigDefinition.getConfigClass();
        if (pluginConfigDefinition.getConfigClass() == null) {
            throw new IllegalArgumentException("pluginConfigDefinition : " + pluginConfigDefinition + " configClass can not be null");
        }
        String fileName = pluginConfigDefinition.getFileName();
        if (pluginConfigDefinition.getFileName() == null || "".equals(pluginConfigDefinition.getFileName())) {
            throw new IllegalArgumentException("pluginConfigDefinition : " + pluginConfigDefinition + " fileName can not be empty");
        }
        PluginConfigFileLoader pluginResourceLoader = new PluginConfigFileLoader(this.configuration.pluginConfigFilePath(), fileName, this.configuration.environment());
        ResourceWrapper resourceWrapper = pluginResourceLoader.load(basePlugin);
        if (resourceWrapper == null) {
            return null;
        }
        List<Resource> resources = resourceWrapper.getResources();
        if (resources.isEmpty() || resources.size() != 1) {
            return null;
        }
        Object o = this.parse(resources.get(0), configClass);
        if (o == null) {
            return configClass.newInstance();
        }
        return o;
    }

    protected abstract Object parse(Resource var1, Class<?> var2) throws Exception;
}

