/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.bean;

import com.gitee.starblues.annotation.ConfigDefinition;
import com.gitee.starblues.factory.PluginInfoContainer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.bean.configuration.ConfigurationParser;
import com.gitee.starblues.factory.process.pipe.bean.configuration.PluginConfigDefinition;
import com.gitee.starblues.factory.process.pipe.bean.configuration.YamlConfigurationParser;
import com.gitee.starblues.integration.IntegrationConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class ConfigBeanProcessor
implements PluginPipeProcessor {
    private static final String KEY = "ConfigBeanProcessor";
    private final ConfigurationParser configurationParser;
    private final DefaultListableBeanFactory defaultListableBeanFactory;

    public ConfigBeanProcessor(ApplicationContext mainApplicationContext) {
        IntegrationConfiguration integrationConfiguration = (IntegrationConfiguration)mainApplicationContext.getBean(IntegrationConfiguration.class);
        this.configurationParser = new YamlConfigurationParser(integrationConfiguration);
        this.defaultListableBeanFactory = (DefaultListableBeanFactory)mainApplicationContext.getAutowireCapableBeanFactory();
    }

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        List<Class<?>> configDefinitions = pluginRegistryInfo.getGroupClasses("config_definition");
        if (configDefinitions == null || configDefinitions.isEmpty()) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        HashSet<String> beanNames = new HashSet<String>();
        for (Class<?> aClass : configDefinitions) {
            String beanName = this.registry(pluginRegistryInfo, aClass);
            if (StringUtils.isEmpty((Object)beanName)) continue;
            beanNames.add(beanName);
            PluginInfoContainer.addRegisterBeanName(pluginId, beanName);
        }
        pluginRegistryInfo.addProcessorInfo(KEY, beanNames);
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Set beanNames = (Set)pluginRegistryInfo.getProcessorInfo(KEY);
        if (beanNames == null) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        for (String beanName : beanNames) {
            if (!this.defaultListableBeanFactory.containsSingleton(beanName)) continue;
            this.defaultListableBeanFactory.destroySingleton(beanName);
            PluginInfoContainer.removeRegisterBeanName(pluginId, beanName);
        }
    }

    private String registry(PluginRegistryInfo pluginRegistryInfo, Class<?> aClass) throws Exception {
        ConfigDefinition configDefinition = aClass.getAnnotation(ConfigDefinition.class);
        if (configDefinition == null) {
            return null;
        }
        String fileName = configDefinition.value();
        if (StringUtils.isEmpty((Object)fileName)) {
            throw new IllegalArgumentException(aClass.getName() + " configDefinition value is null");
        }
        PluginConfigDefinition pluginConfigDefinition = new PluginConfigDefinition(fileName, aClass);
        Object parseObject = this.configurationParser.parse(pluginRegistryInfo.getBasePlugin(), pluginConfigDefinition);
        String name = configDefinition.name();
        if (StringUtils.isEmpty((Object)name)) {
            name = aClass.getName();
        }
        if (!this.defaultListableBeanFactory.containsSingleton(name)) {
            this.defaultListableBeanFactory.registerSingleton(name, parseObject);
        }
        return name;
    }
}

