/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis.utils;

import com.gitee.starblues.extension.mybatis.utils.PluginMybatisXmlMapperBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.core.io.Resource;

public class MybatisXmlProcess {
    private static MybatisXmlProcess mybatisXmlProcess = null;
    private final Map<String, String> MAPPERS = new ConcurrentHashMap<String, String>();
    private final SqlSessionFactory factory;

    private MybatisXmlProcess(SqlSessionFactory sqlSessionFactory) {
        this.factory = sqlSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MybatisXmlProcess getInstance(SqlSessionFactory sqlSessionFactory) {
        Objects.requireNonNull(sqlSessionFactory);
        if (mybatisXmlProcess != null) return mybatisXmlProcess;
        Class<MybatisXmlProcess> clazz = MybatisXmlProcess.class;
        synchronized (MybatisXmlProcess.class) {
            if (mybatisXmlProcess != null) return mybatisXmlProcess;
            mybatisXmlProcess = new MybatisXmlProcess(sqlSessionFactory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mybatisXmlProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadXmlResource(List<Resource> resources, ClassLoader pluginClassLoader) throws Exception {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        Configuration configuration = this.factory.getConfiguration();
        ClassLoader defaultClassLoader = Resources.getDefaultClassLoader();
        try {
            Resources.setDefaultClassLoader((ClassLoader)pluginClassLoader);
            for (Resource resource : resources) {
                InputStream inputStream = resource.getInputStream();
                try {
                    PluginMybatisXmlMapperBuilder xmlMapperBuilder = new PluginMybatisXmlMapperBuilder(inputStream, configuration, resource.toString(), configuration.getSqlFragments(), pluginClassLoader);
                    xmlMapperBuilder.parse();
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        finally {
            ErrorContext.instance().reset();
            Resources.setDefaultClassLoader((ClassLoader)defaultClassLoader);
        }
    }

    @Deprecated
    public boolean isChange(List<Resource> resources) throws IOException {
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        boolean isChanged = false;
        for (Resource resource : resources) {
            String key = resource.getURI().toString();
            String value = this.getModify(resource);
            if (value.equals(this.MAPPERS.get(key))) continue;
            isChanged = true;
            this.MAPPERS.put(key, value);
        }
        return isChanged;
    }

    @Deprecated
    private void removeConfig(Configuration configuration) throws Exception {
        Class<?> classConfig = configuration.getClass();
        this.clearMap(classConfig, configuration, "mappedStatements");
        this.clearMap(classConfig, configuration, "caches");
        this.clearMap(classConfig, configuration, "resultMaps");
        this.clearMap(classConfig, configuration, "parameterMaps");
        this.clearMap(classConfig, configuration, "keyGenerators");
        this.clearMap(classConfig, configuration, "sqlFragments");
        this.clearSet(classConfig, configuration, "loadedResources");
    }

    @Deprecated
    private void clearMap(Class<?> classConfig, Configuration configuration, String fieldName) throws Exception {
        Field field = classConfig.getDeclaredField(fieldName);
        field.setAccessible(true);
        ((Map)field.get(configuration)).clear();
    }

    private void clearSet(Class<?> classConfig, Configuration configuration, String fieldName) throws Exception {
        Field field = classConfig.getDeclaredField(fieldName);
        field.setAccessible(true);
        ((Set)field.get(configuration)).clear();
    }

    private String getModify(Resource resource) throws IOException {
        return resource.contentLength() + "-" + resource.lastModified();
    }
}

