/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.gitee.starblues.extension.mybatis.configuration.SpringBootMybatisConfig;
import com.gitee.starblues.loader.PluginResourceLoader;
import com.gitee.starblues.loader.ResourceWrapper;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.OrderPriority;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

public class PluginMybatisXmlLoader
implements PluginResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginMybatisXmlLoader.class);
    public static final String KEY = "PluginMybatisXmlLoader";
    private static final String TYPE_FILE = "file";
    private static final String TYPE_CLASSPATH = "classpath";
    private static final String TYPE_PACKAGE = "package";

    PluginMybatisXmlLoader() {
    }

    public String key() {
        return KEY;
    }

    public ResourceWrapper load(BasePlugin basePlugin) throws Exception {
        if (!(basePlugin instanceof SpringBootMybatisConfig)) {
            LOG.warn("Plugin '{}' not implements SpringBootMybatisConfig, If you need to use mybatis in the plugin,Please implements SpringBootMybatisConfig interface", (Object)basePlugin.getWrapper().getPluginId());
            return null;
        }
        SpringBootMybatisConfig springBootMybatisConfig = (SpringBootMybatisConfig)basePlugin;
        Set<String> mybatisMapperXmlLocationsMatch = springBootMybatisConfig.mybatisMapperXmlLocationsMatch();
        if (mybatisMapperXmlLocationsMatch == null || mybatisMapperXmlLocationsMatch.isEmpty()) {
            LOG.warn("SpringBootMybatisConfig -> mybatisMapperXmlLocationsMatch return is empty, Please check configuration");
            return new ResourceWrapper();
        }
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(basePlugin.getWrapper().getPluginClassLoader());
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String mybatisMapperXmlLocationMatch : mybatisMapperXmlLocationsMatch) {
            List<Resource> loadResources;
            if (StringUtils.isEmpty((Object)mybatisMapperXmlLocationMatch) || (loadResources = this.load((ResourcePatternResolver)resourcePatternResolver, mybatisMapperXmlLocationMatch)) == null || loadResources.isEmpty()) continue;
            resources.addAll(loadResources);
        }
        return new ResourceWrapper(resources);
    }

    public void unload(BasePlugin basePlugin, ResourceWrapper resourceWrapper) throws Exception {
    }

    public OrderPriority order() {
        return OrderPriority.getHighPriority();
    }

    private List<Resource> load(ResourcePatternResolver resourcePatternResolver, String mybatisMapperXmlLocationMatch) throws Exception {
        String[] split = mybatisMapperXmlLocationMatch.split(":");
        if (split.length != 2) {
            return null;
        }
        String type = split[0];
        String location = split[1];
        String matchLocation = null;
        if (Objects.equals(type, TYPE_CLASSPATH) || Objects.equals(type, TYPE_FILE)) {
            matchLocation = location;
        } else if (Objects.equals(type, TYPE_PACKAGE)) {
            matchLocation = location.replace(".", "/");
        }
        if (matchLocation == null) {
            LOG.error("mybatisMapperXmlLocation {} illegal", (Object)mybatisMapperXmlLocationMatch);
            return null;
        }
        try {
            Resource[] resources = resourcePatternResolver.getResources(matchLocation);
            return Arrays.asList(resources);
        }
        catch (IOException e) {
            LOG.error("mybatisMapperXmlLocation match error : {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }
}

