/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.IStorageManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class BinaryUploader {
    private IStorageManager storage;

    public BinaryUploader(IStorageManager storage) {
        this.storage = storage;
    }

    public State save(HttpServletRequest request, Map<String, Object> conf) {
        if (request instanceof MultipartRequest) {
            return this.doSave((MultipartRequest)request, conf);
        }
        return this.doSave(request, conf);
    }

    protected State doSave(MultipartRequest request, Map<String, Object> conf) {
        Map map = request.getFileMap();
        try {
            MultipartFile file = null;
            for (MultipartFile temp : map.values()) {
                if (temp.isEmpty()) continue;
                file = temp;
                break;
            }
            if (file == null) {
                return new BaseState(false, 7);
            }
            String savePath = (String)conf.get("savePath");
            String originFileName = file.getOriginalFilename();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            savePath = savePath + suffix;
            long maxSize = (Long)conf.get("maxSize");
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            savePath = PathFormat.parse(savePath, originFileName);
            String rootPath = (String)conf.get("rootPath");
            InputStream is = file.getInputStream();
            State storageState = this.storage.saveFileByInputStream(is, rootPath, savePath, maxSize);
            is.close();
            if (storageState.isSuccess()) {
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            return storageState;
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
    }

    protected State doSave(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        FileItemStream fileStream = null;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            FileItemIterator iterator = upload.getItemIterator(request);
            while (iterator.hasNext() && (fileStream = iterator.next()).isFormField()) {
                fileStream = null;
            }
            if (fileStream == null) {
                return new BaseState(false, 7);
            }
            String savePath = (String)conf.get("savePath");
            String originFileName = fileStream.getName();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            savePath = savePath + suffix;
            long maxSize = (Long)conf.get("maxSize");
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            savePath = PathFormat.parse(savePath, originFileName);
            String rootPath = (String)conf.get("rootPath");
            InputStream is = fileStream.openStream();
            State storageState = this.storage.saveFileByInputStream(is, rootPath, savePath, maxSize);
            is.close();
            if (storageState.isSuccess()) {
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            return storageState;
        }
        catch (FileUploadException e) {
            return new BaseState(false, 6);
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

