/*
 * Decompiled with CFR 0.152.
 */
package com.newki.round_circle_layout.policy;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.graphics.ColorUtils;
import com.newki.round_circle_layout.policy.AbsRoundCirclePolicy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010!\u001a\u00020\u001dH\u0002J\u0012\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J(\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0016J\u0012\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\rH\u0016J\u0012\u0010.\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\rH\u0016J\u0012\u00101\u001a\u00020\u001d2\b\u00102\u001a\u0004\u0018\u00010+H\u0002J\b\u00103\u001a\u00020\u001dH\u0002J\b\u00104\u001a\u00020\u001dH\u0002J\b\u00105\u001a\u00020\u001dH\u0002J\b\u00106\u001a\u00020\u001dH\u0002J\b\u00107\u001a\u00020\u001dH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/newki/round_circle_layout/policy/RoundCircleLayoutShaderPolicy;", "Lcom/newki/round_circle_layout/policy/AbsRoundCirclePolicy;", "view", "Landroid/view/View;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "attrs", "", "attrIndex", "(Landroid/view/View;Landroid/content/Context;Landroid/util/AttributeSet;[I[I)V", "mBitmapHeight", "", "mBitmapPaint", "Landroid/graphics/Paint;", "mBitmapShader", "Landroid/graphics/BitmapShader;", "mBitmapWidth", "mDrawableRect", "Landroid/graphics/RectF;", "mPath", "Landroid/graphics/Path;", "mShaderMatrix", "Landroid/graphics/Matrix;", "mShadowPaint", "mShadowPath", "mShadowRect", "afterDispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "beforeDispatchDraw", "initViewData", "onDraw", "", "onLayout", "left", "top", "right", "bottom", "setBackground", "background", "Landroid/graphics/drawable/Drawable;", "setBackgroundColor", "color", "setBackgroundDrawable", "setBackgroundResource", "resid", "setRoundBackgroundDrawable", "drawable", "setupBG", "setupRect", "setupRoundPath", "setupShadow", "updateShaderMatrix", "round_img_lib_release"})
public final class RoundCircleLayoutShaderPolicy
extends AbsRoundCirclePolicy {
    @Nullable
    private BitmapShader mBitmapShader;
    private Path mPath;
    private RectF mDrawableRect;
    private Paint mBitmapPaint;
    private Matrix mShaderMatrix;
    private int mBitmapWidth;
    private int mBitmapHeight;
    @NotNull
    private final RectF mShadowRect;
    @NotNull
    private final Path mShadowPath;
    private Paint mShadowPaint;

    public RoundCircleLayoutShaderPolicy(@NotNull View view, @NotNull Context context, @Nullable AttributeSet attributeSet, @NotNull int[] attrs, @NotNull int[] attrIndex) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)attrIndex, (String)"attrIndex");
        super(view, context, attributeSet, attrs, attrIndex);
        this.mShadowRect = new RectF();
        this.mShadowPath = new Path();
        this.initViewData();
    }

    private final void initViewData() {
        this.getMContainer().setWillNotDraw(false);
        this.mDrawableRect = new RectF();
        this.mPath = new Path();
        this.mBitmapPaint = new Paint();
        this.mShaderMatrix = new Matrix();
        this.mShadowPaint = new Paint();
    }

    private final void setupRect() {
        RectF rectF = this.calculateBounds();
        float let = rectF.left + (float)this.getMShadowSize();
        float top = rectF.top + (float)this.getMShadowSize();
        float right = rectF.right - (float)this.getMShadowSize();
        float bottom = rectF.bottom - (float)this.getMShadowSize();
        RectF rectF2 = this.mDrawableRect;
        if (rectF2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
            rectF2 = null;
        }
        rectF2.set(let, top, right, bottom);
        float shadowLet = 0.0f;
        float shadowTop = 0.0f;
        float shadowRight = 0.0f;
        float shadowBottom = 0.0f;
        if (this.getMShadowOffsetX() > 0) {
            shadowLet = let + (float)this.getMShadowOffsetX();
            shadowRight = right;
        } else {
            shadowLet = let;
            shadowRight = right + (float)this.getMShadowOffsetX();
        }
        if (this.getMShadowOffsetY() > 0) {
            shadowTop = top + (float)this.getMShadowOffsetY();
            shadowBottom = bottom;
        } else {
            shadowTop = top;
            shadowBottom = bottom + (float)this.getMShadowOffsetY();
        }
        this.mShadowRect.set(shadowLet, shadowTop, shadowRight, shadowBottom);
    }

    private final void setupShadow() {
        if (this.getMShadowSize() > 0) {
            Paint paint;
            Paint paint2 = this.mShadowPaint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                paint2 = null;
            }
            paint2.setColor(0);
            Paint paint3 = this.mShadowPaint;
            if (paint3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                paint3 = null;
            }
            paint3.setStyle(Paint.Style.STROKE);
            Paint paint4 = this.mShadowPaint;
            if (paint4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                paint4 = null;
            }
            paint4.setStrokeWidth((float)(this.getMShadowSize() / 4));
            if (ColorUtils.setAlphaComponent((int)this.getMShadowColor(), (int)255) == this.getMShadowColor()) {
                this.setMShadowColor(ColorUtils.setAlphaComponent((int)this.getMShadowColor(), (int)254));
            }
            if ((paint = this.mShadowPaint) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                paint = null;
            }
            paint.setColor(this.getMShadowColor());
            Paint paint5 = this.mShadowPaint;
            if (paint5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                paint5 = null;
            }
            paint5.setMaskFilter((MaskFilter)new BlurMaskFilter((float)this.getMShadowSize() / 1.2f, BlurMaskFilter.Blur.NORMAL));
        } else {
            Paint paint = this.mShadowPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                paint = null;
            }
            paint.clearShadowLayer();
        }
    }

    private final void setupBG() {
        if (this.getMRoundBackgroundDrawable() != null && this.getMRoundBackgroundBitmap() != null) {
            Paint paint;
            Bitmap bitmap = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap);
            this.mBitmapWidth = bitmap.getWidth();
            Bitmap bitmap2 = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap2);
            this.mBitmapHeight = bitmap2.getHeight();
            Bitmap bitmap3 = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap3);
            this.mBitmapShader = new BitmapShader(bitmap3, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            Bitmap bitmap4 = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap4);
            if (bitmap4.getWidth() != 2) {
                this.updateShaderMatrix();
            }
            if ((paint = this.mBitmapPaint) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mBitmapPaint");
                paint = null;
            }
            paint.setAntiAlias(true);
            Paint paint2 = this.mBitmapPaint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mBitmapPaint");
                paint2 = null;
            }
            paint2.setShader((Shader)this.mBitmapShader);
        }
    }

    @Override
    public void beforeDispatchDraw(@Nullable Canvas canvas) {
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            Path path = this.mPath;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPath");
                path = null;
            }
            canvas2.clipPath(path);
        }
    }

    @Override
    public void afterDispatchDraw(@Nullable Canvas canvas) {
    }

    @Override
    public boolean onDraw(@Nullable Canvas canvas) {
        if (this.isCircleType()) {
            if (this.getMShadowSize() > 0) {
                Canvas canvas2 = canvas;
                if (canvas2 != null) {
                    Paint paint = this.mShadowPaint;
                    if (paint == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                        paint = null;
                    }
                    canvas2.drawOval(this.mShadowRect, paint);
                }
            }
            Canvas canvas3 = canvas;
            if (canvas3 != null) {
                RectF rectF = this.mDrawableRect;
                if (rectF == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                    rectF = null;
                }
                float f = rectF.centerX();
                RectF rectF2 = this.mDrawableRect;
                if (rectF2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                    rectF2 = null;
                }
                float f2 = rectF2.centerY();
                RectF rectF3 = this.mDrawableRect;
                if (rectF3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                    rectF3 = null;
                }
                float f3 = rectF3.height() / 2.0f;
                RectF rectF4 = this.mDrawableRect;
                if (rectF4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                    rectF4 = null;
                }
                float f4 = Math.min(f3, rectF4.width() / 2.0f);
                Paint paint = this.mBitmapPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mBitmapPaint");
                    paint = null;
                }
                canvas3.drawCircle(f, f2, f4, paint);
            }
        } else if (this.getMTopLeft() > 0.0f || this.getMTopRight() > 0.0f || this.getMBottomLeft() > 0.0f || this.getMBottomRight() > 0.0f) {
            if (this.getMShadowSize() > 0) {
                this.mShadowPath.reset();
                float[] fArray = new float[]{this.getMTopLeft(), this.getMTopLeft(), this.getMTopRight(), this.getMTopRight(), this.getMBottomRight(), this.getMBottomRight(), this.getMBottomLeft(), this.getMBottomLeft()};
                this.mShadowPath.addRoundRect(this.mShadowRect, fArray, Path.Direction.CW);
                Canvas canvas4 = canvas;
                if (canvas4 != null) {
                    Paint paint = this.mShadowPaint;
                    if (paint == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                        paint = null;
                    }
                    canvas4.drawPath(this.mShadowPath, paint);
                }
            }
            Path path = new Path();
            RectF rectF = this.mDrawableRect;
            if (rectF == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                rectF = null;
            }
            float[] fArray = new float[]{this.getMTopLeft(), this.getMTopLeft(), this.getMTopRight(), this.getMTopRight(), this.getMBottomRight(), this.getMBottomRight(), this.getMBottomLeft(), this.getMBottomLeft()};
            path.addRoundRect(rectF, fArray, Path.Direction.CW);
            Canvas canvas5 = canvas;
            if (canvas5 != null) {
                Paint paint = this.mBitmapPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mBitmapPaint");
                    paint = null;
                }
                canvas5.drawPath(path, paint);
            }
        } else {
            if (this.getMShadowSize() > 0) {
                Canvas canvas6 = canvas;
                if (canvas6 != null) {
                    float f = this.getMRoundRadius();
                    float f5 = this.getMRoundRadius();
                    Paint paint = this.mShadowPaint;
                    if (paint == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mShadowPaint");
                        paint = null;
                    }
                    canvas6.drawRoundRect(this.mShadowRect, f, f5, paint);
                }
            }
            Canvas canvas7 = canvas;
            if (canvas7 != null) {
                RectF rectF = this.mDrawableRect;
                if (rectF == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                    rectF = null;
                }
                float f = this.getMRoundRadius();
                float f6 = this.getMRoundRadius();
                Paint paint = this.mBitmapPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mBitmapPaint");
                    paint = null;
                }
                canvas7.drawRoundRect(rectF, f, f6, paint);
            }
        }
        return true;
    }

    private final void updateShaderMatrix() {
        Matrix matrix;
        float scale = 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        Matrix matrix2 = this.mShaderMatrix;
        if (matrix2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mShaderMatrix");
            matrix2 = null;
        }
        matrix2.set(null);
        float f = this.mBitmapWidth;
        RectF rectF = this.mDrawableRect;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
            rectF = null;
        }
        float f2 = f * rectF.height();
        RectF rectF2 = this.mDrawableRect;
        if (rectF2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
            rectF2 = null;
        }
        if (f2 > rectF2.width() * (float)this.mBitmapHeight) {
            RectF rectF3 = this.mDrawableRect;
            if (rectF3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                rectF3 = null;
            }
            scale = rectF3.height() / (float)this.mBitmapHeight;
            RectF rectF4 = this.mDrawableRect;
            if (rectF4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                rectF4 = null;
            }
            dx = (rectF4.width() - (float)this.mBitmapWidth * scale) * 0.5f;
        } else {
            RectF rectF5 = this.mDrawableRect;
            if (rectF5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                rectF5 = null;
            }
            scale = rectF5.width() / (float)this.mBitmapWidth;
            RectF rectF6 = this.mDrawableRect;
            if (rectF6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                rectF6 = null;
            }
            dy = (rectF6.height() - (float)this.mBitmapHeight * scale) * 0.5f;
        }
        if ((matrix = this.mShaderMatrix) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mShaderMatrix");
            matrix = null;
        }
        matrix.setScale(scale, scale);
        if (this.isBGCenterCrop()) {
            Matrix matrix3 = this.mShaderMatrix;
            if (matrix3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShaderMatrix");
                matrix3 = null;
            }
            float f3 = (int)(dx + 0.5f);
            RectF rectF7 = this.mDrawableRect;
            if (rectF7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                rectF7 = null;
            }
            float f4 = f3 + rectF7.left;
            float f5 = (int)(dy + 0.5f);
            RectF rectF8 = this.mDrawableRect;
            if (rectF8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDrawableRect");
                rectF8 = null;
            }
            matrix3.postTranslate(f4, f5 + rectF8.top);
        }
        BitmapShader bitmapShader = this.mBitmapShader;
        if (bitmapShader != null) {
            BitmapShader it = bitmapShader;
            boolean bl = false;
            Matrix matrix4 = this.mShaderMatrix;
            if (matrix4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mShaderMatrix");
                matrix4 = null;
            }
            it.setLocalMatrix(matrix4);
        }
    }

    @Override
    public void onLayout(int left, int top, int right, int bottom) {
        this.setupRect();
        this.setupBG();
        this.setupShadow();
        this.setupRoundPath();
    }

    private final void setupRoundPath() {
        Path path = this.mPath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPath");
            path = null;
        }
        path.reset();
        if (this.isCircleType()) {
            Path path2 = this.mPath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPath");
                path2 = null;
            }
            path2.addOval(this.calculateBounds(), Path.Direction.CCW);
        } else if (this.getMTopLeft() > 0.0f || this.getMTopRight() > 0.0f || this.getMBottomLeft() > 0.0f || this.getMBottomRight() > 0.0f) {
            Path path3 = this.mPath;
            if (path3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPath");
                path3 = null;
            }
            float[] fArray = new float[]{this.getMTopLeft(), this.getMTopLeft(), this.getMTopRight(), this.getMTopRight(), this.getMBottomRight(), this.getMBottomRight(), this.getMBottomLeft(), this.getMBottomLeft()};
            path3.addRoundRect(this.calculateBounds(), fArray, Path.Direction.CCW);
        } else {
            Path path4 = this.mPath;
            if (path4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPath");
                path4 = null;
            }
            path4.addRoundRect(this.calculateBounds(), this.getMRoundRadius(), this.getMRoundRadius(), Path.Direction.CCW);
        }
    }

    @Override
    public void setBackground(@Nullable Drawable background) {
        this.setRoundBackgroundDrawable(background);
    }

    @Override
    public void setBackgroundColor(int color) {
        ColorDrawable drawable = new ColorDrawable(color);
        this.setRoundBackgroundDrawable((Drawable)drawable);
    }

    @Override
    public void setBackgroundResource(int resid) {
        Drawable drawable = this.getMContainer().getContext().getResources().getDrawable(resid);
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"mContainer.context.resources.getDrawable(resid)");
        Drawable drawable2 = drawable;
        this.setRoundBackgroundDrawable(drawable2);
    }

    @Override
    public void setBackgroundDrawable(@Nullable Drawable background) {
        this.setRoundBackgroundDrawable(background);
    }

    private final void setRoundBackgroundDrawable(Drawable drawable) {
        this.setMRoundBackgroundDrawable(drawable);
        this.setMRoundBackgroundBitmap(this.getBitmapFromDrawable(this.getMRoundBackgroundDrawable()));
        this.setupBG();
        this.getMContainer().invalidate();
    }
}

