/*
 * Decompiled with CFR 0.152.
 */
package com.newki.round_circle_layout.policy;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.core.graphics.ColorUtils;
import com.newki.round_circle_layout.policy.AbsRoundCirclePolicy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017J\u0012\u0010 \u001a\u00020!2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J(\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\rH\u0016J\u0012\u0010'\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\rH\u0016J\u0012\u0010,\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\rH\u0016J\u0012\u0010/\u001a\u00020\u001c2\b\u00100\u001a\u0004\u0018\u00010)H\u0002J\b\u00101\u001a\u00020\u001cH\u0002J\b\u00102\u001a\u00020\u001cH\u0002J\b\u00103\u001a\u00020\u001cH\u0002J\b\u00104\u001a\u00020\u001cH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/newki/round_circle_layout/policy/RoundCircleLayoutOutlinePolicy;", "Lcom/newki/round_circle_layout/policy/AbsRoundCirclePolicy;", "view", "Landroid/view/View;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "attrs", "", "attrIndex", "(Landroid/view/View;Landroid/content/Context;Landroid/util/AttributeSet;[I[I)V", "mBitmapHeight", "", "mBitmapPaint", "Landroid/graphics/Paint;", "mBitmapShader", "Landroid/graphics/BitmapShader;", "mBitmapWidth", "mDrawableRect", "Landroid/graphics/RectF;", "mShaderMatrix", "Landroid/graphics/Matrix;", "mShadowPaint", "mShadowPath", "Landroid/graphics/Path;", "mShadowRect", "afterDispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "beforeDispatchDraw", "onDraw", "", "onLayout", "left", "top", "right", "bottom", "setBackground", "background", "Landroid/graphics/drawable/Drawable;", "setBackgroundColor", "color", "setBackgroundDrawable", "setBackgroundResource", "resid", "setRoundBackgroundDrawable", "drawable", "setupBG", "setupRect", "setupShadow", "updateShaderMatrix", "round_img_lib_release"})
public final class RoundCircleLayoutOutlinePolicy
extends AbsRoundCirclePolicy {
    @Nullable
    private BitmapShader mBitmapShader;
    @NotNull
    private RectF mDrawableRect;
    @NotNull
    private Paint mBitmapPaint;
    @NotNull
    private Matrix mShaderMatrix;
    private int mBitmapWidth;
    private int mBitmapHeight;
    @NotNull
    private final RectF mShadowRect;
    @NotNull
    private final Path mShadowPath;
    @NotNull
    private Paint mShadowPaint;

    public RoundCircleLayoutOutlinePolicy(@NotNull View view, @NotNull Context context, @Nullable AttributeSet attributeSet, @NotNull int[] attrs, @NotNull int[] attrIndex) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)attrIndex, (String)"attrIndex");
        super(view, context, attributeSet, attrs, attrIndex);
        this.mShadowRect = new RectF();
        this.mShadowPath = new Path();
        this.getMContainer().setWillNotDraw(false);
        this.mDrawableRect = new RectF();
        this.mBitmapPaint = new Paint();
        this.mShaderMatrix = new Matrix();
        this.mShadowPaint = new Paint();
    }

    private final void setupRect() {
        RectF rectF = this.calculateBounds();
        float let = rectF.left + (float)this.getMShadowSize();
        float top = rectF.top + (float)this.getMShadowSize();
        float right = rectF.right - (float)this.getMShadowSize();
        float bottom = rectF.bottom - (float)this.getMShadowSize();
        this.mDrawableRect.set(let, top, right, bottom);
        float shadowLet = 0.0f;
        float shadowTop = 0.0f;
        float shadowRight = 0.0f;
        float shadowBottom = 0.0f;
        if (this.getMShadowOffsetX() > 0) {
            shadowLet = let + (float)this.getMShadowOffsetX();
            shadowRight = right;
        } else {
            shadowLet = let;
            shadowRight = right + (float)this.getMShadowOffsetX();
        }
        if (this.getMShadowOffsetY() > 0) {
            shadowTop = top + (float)this.getMShadowOffsetY();
            shadowBottom = bottom;
        } else {
            shadowTop = top;
            shadowBottom = bottom + (float)this.getMShadowOffsetY();
        }
        this.mShadowRect.set(shadowLet, shadowTop, shadowRight, shadowBottom);
    }

    private final void setupBG() {
        if (this.getMRoundBackgroundDrawable() != null && this.getMRoundBackgroundBitmap() != null) {
            Bitmap bitmap = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap);
            this.mBitmapWidth = bitmap.getWidth();
            Bitmap bitmap2 = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap2);
            this.mBitmapHeight = bitmap2.getHeight();
            Bitmap bitmap3 = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap3);
            this.mBitmapShader = new BitmapShader(bitmap3, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            Bitmap bitmap4 = this.getMRoundBackgroundBitmap();
            Intrinsics.checkNotNull((Object)bitmap4);
            if (bitmap4.getWidth() != 2) {
                this.updateShaderMatrix();
            }
            this.mBitmapPaint.setAntiAlias(true);
            this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        }
    }

    private final void setupShadow() {
        if (this.getMShadowSize() > 0) {
            this.mShadowPaint.setColor(0);
            this.mShadowPaint.setStyle(Paint.Style.STROKE);
            this.mShadowPaint.setStrokeWidth((float)(this.getMShadowSize() / 4));
            if (ColorUtils.setAlphaComponent((int)this.getMShadowColor(), (int)255) == this.getMShadowColor()) {
                this.setMShadowColor(ColorUtils.setAlphaComponent((int)this.getMShadowColor(), (int)254));
            }
            this.mShadowPaint.setColor(this.getMShadowColor());
            this.mShadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter((float)this.getMShadowSize() / 1.2f, BlurMaskFilter.Blur.NORMAL));
        } else {
            this.mShadowPaint.clearShadowLayer();
        }
    }

    @Override
    public boolean onDraw(@Nullable Canvas canvas) {
        if (this.isCircleType()) {
            if (this.getMShadowSize() > 0) {
                Canvas canvas2 = canvas;
                if (canvas2 != null) {
                    canvas2.drawOval(this.mShadowRect, this.mShadowPaint);
                }
            }
            Canvas canvas3 = canvas;
            if (canvas3 != null) {
                canvas3.drawCircle(this.mDrawableRect.centerX(), this.mDrawableRect.centerY(), Math.min(this.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f), this.mBitmapPaint);
            }
        } else if (this.getMTopLeft() > 0.0f || this.getMTopRight() > 0.0f || this.getMBottomLeft() > 0.0f || this.getMBottomRight() > 0.0f) {
            if (this.getMShadowSize() > 0) {
                this.mShadowPath.reset();
                float[] fArray = new float[]{this.getMTopLeft(), this.getMTopLeft(), this.getMTopRight(), this.getMTopRight(), this.getMBottomRight(), this.getMBottomRight(), this.getMBottomLeft(), this.getMBottomLeft()};
                this.mShadowPath.addRoundRect(this.mShadowRect, fArray, Path.Direction.CW);
                Canvas canvas4 = canvas;
                if (canvas4 != null) {
                    canvas4.drawPath(this.mShadowPath, this.mShadowPaint);
                }
            }
            Path path = new Path();
            float[] fArray = new float[]{this.getMTopLeft(), this.getMTopLeft(), this.getMTopRight(), this.getMTopRight(), this.getMBottomRight(), this.getMBottomRight(), this.getMBottomLeft(), this.getMBottomLeft()};
            path.addRoundRect(this.mDrawableRect, fArray, Path.Direction.CW);
            Canvas canvas5 = canvas;
            if (canvas5 != null) {
                canvas5.drawPath(path, this.mBitmapPaint);
            }
        } else {
            if (this.getMShadowSize() > 0) {
                Canvas canvas6 = canvas;
                if (canvas6 != null) {
                    canvas6.drawRoundRect(this.mShadowRect, this.getMRoundRadius(), this.getMRoundRadius(), this.mShadowPaint);
                }
            }
            Canvas canvas7 = canvas;
            if (canvas7 != null) {
                canvas7.drawRoundRect(this.mDrawableRect, this.getMRoundRadius(), this.getMRoundRadius(), this.mBitmapPaint);
            }
        }
        return true;
    }

    @Override
    @TargetApi(value=21)
    public void beforeDispatchDraw(@Nullable Canvas canvas) {
        this.getMContainer().setClipToOutline(true);
    }

    @Override
    @TargetApi(value=21)
    public void afterDispatchDraw(@Nullable Canvas canvas) {
        this.getMContainer().setOutlineProvider(new ViewOutlineProvider(this){
            final /* synthetic */ RoundCircleLayoutOutlinePolicy this$0;
            {
                this.this$0 = $receiver;
            }

            public void getOutline(@NotNull View view, @NotNull Outline outline) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
                if (this.this$0.isCircleType()) {
                    Rect bounds = new Rect();
                    this.this$0.calculateBounds().roundOut(bounds);
                    outline.setRoundRect(bounds, (float)bounds.width() / 2.0f);
                } else if (this.this$0.getMTopLeft() > 0.0f || this.this$0.getMTopRight() > 0.0f || this.this$0.getMBottomLeft() > 0.0f || this.this$0.getMBottomRight() > 0.0f) {
                    Path path = new Path();
                    float[] fArray = new float[]{this.this$0.getMTopLeft(), this.this$0.getMTopLeft(), this.this$0.getMTopRight(), this.this$0.getMTopRight(), this.this$0.getMBottomRight(), this.this$0.getMBottomRight(), this.this$0.getMBottomLeft(), this.this$0.getMBottomLeft()};
                    path.addRoundRect(this.this$0.calculateBounds(), fArray, Path.Direction.CCW);
                    outline.setConvexPath(path);
                } else {
                    outline.setRoundRect(0, 0, this.this$0.getMContainer().getWidth(), this.this$0.getMContainer().getHeight(), this.this$0.getMRoundRadius());
                }
            }
        });
    }

    private final void updateShaderMatrix() {
        float scale = 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        this.mShaderMatrix.set(null);
        if ((float)this.mBitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * (float)this.mBitmapHeight) {
            scale = this.mDrawableRect.height() / (float)this.mBitmapHeight;
            dx = (this.mDrawableRect.width() - (float)this.mBitmapWidth * scale) * 0.5f;
        } else {
            scale = this.mDrawableRect.width() / (float)this.mBitmapWidth;
            dy = (this.mDrawableRect.height() - (float)this.mBitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.setScale(scale, scale);
        if (this.isBGCenterCrop()) {
            this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.mDrawableRect.left, (float)((int)(dy + 0.5f)) + this.mDrawableRect.top);
        }
        BitmapShader bitmapShader = this.mBitmapShader;
        if (bitmapShader != null) {
            BitmapShader it = bitmapShader;
            boolean bl = false;
            it.setLocalMatrix(this.mShaderMatrix);
        }
    }

    @Override
    public void onLayout(int left, int top, int right, int bottom) {
        this.setupRect();
        this.setupBG();
        this.setupShadow();
    }

    @Override
    public void setBackground(@Nullable Drawable background) {
        this.setRoundBackgroundDrawable(background);
    }

    @Override
    public void setBackgroundColor(int color) {
        ColorDrawable drawable = new ColorDrawable(color);
        this.setRoundBackgroundDrawable((Drawable)drawable);
    }

    @Override
    public void setBackgroundResource(int resid) {
        Drawable drawable = this.getMContainer().getContext().getResources().getDrawable(resid);
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"mContainer.context.resources.getDrawable(resid)");
        Drawable drawable2 = drawable;
        this.setRoundBackgroundDrawable(drawable2);
    }

    @Override
    public void setBackgroundDrawable(@Nullable Drawable background) {
        this.setRoundBackgroundDrawable(background);
    }

    private final void setRoundBackgroundDrawable(Drawable drawable) {
        this.setMRoundBackgroundDrawable(drawable);
        this.setMRoundBackgroundBitmap(this.getBitmapFromDrawable(this.getMRoundBackgroundDrawable()));
        this.setupBG();
        this.getMContainer().invalidate();
    }
}

