/*
 * Decompiled with CFR 0.152.
 */
package com.newki.round_circle_layout.policy;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.newki.round_circle_layout.policy.IRoundCirclePolicy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010C\u001a\u00020DH\u0004J\u0018\u0010E\u001a\u00020/2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0014H\u0004J\u0014\u0010G\u001a\u0004\u0018\u00010 2\b\u0010H\u001a\u0004\u0018\u00010&H\u0004J*\u0010I\u001a\u00020J2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010K\u001a\u00020\tH\u0002J\b\u0010L\u001a\u00020\rH\u0016J\u0012\u0010M\u001a\u00020\r2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\u0010\u0010P\u001a\u00020J2\u0006\u0010H\u001a\u00020&H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u0011\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0016\"\u0004\b-\u0010\u0018R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u001a\u00107\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00101\"\u0004\b9\u00103R\u001a\u0010:\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00101\"\u0004\b<\u00103R\u001a\u0010=\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0016\"\u0004\b?\u0010\u0018R\u001a\u0010@\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0016\"\u0004\bB\u0010\u0018\u00a8\u0006Q"}, d2={"Lcom/newki/round_circle_layout/policy/AbsRoundCirclePolicy;", "Lcom/newki/round_circle_layout/policy/IRoundCirclePolicy;", "view", "Landroid/view/View;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "attrs", "", "attrIndex", "(Landroid/view/View;Landroid/content/Context;Landroid/util/AttributeSet;[I[I)V", "isBGCenterCrop", "", "()Z", "setBGCenterCrop", "(Z)V", "isCircleType", "setCircleType", "mBottomLeft", "", "getMBottomLeft", "()F", "setMBottomLeft", "(F)V", "mBottomRight", "getMBottomRight", "setMBottomRight", "mContainer", "getMContainer", "()Landroid/view/View;", "mRoundBackgroundBitmap", "Landroid/graphics/Bitmap;", "getMRoundBackgroundBitmap", "()Landroid/graphics/Bitmap;", "setMRoundBackgroundBitmap", "(Landroid/graphics/Bitmap;)V", "mRoundBackgroundDrawable", "Landroid/graphics/drawable/Drawable;", "getMRoundBackgroundDrawable", "()Landroid/graphics/drawable/Drawable;", "setMRoundBackgroundDrawable", "(Landroid/graphics/drawable/Drawable;)V", "mRoundRadius", "getMRoundRadius", "setMRoundRadius", "mShadowColor", "", "getMShadowColor", "()I", "setMShadowColor", "(I)V", "mShadowOffsetX", "getMShadowOffsetX", "setMShadowOffsetX", "mShadowOffsetY", "getMShadowOffsetY", "setMShadowOffsetY", "mShadowSize", "getMShadowSize", "setMShadowSize", "mTopLeft", "getMTopLeft", "setMTopLeft", "mTopRight", "getMTopRight", "setMTopRight", "calculateBounds", "Landroid/graphics/RectF;", "dp2px", "dpValue", "getBitmapFromDrawable", "drawable", "initialize", "", "attrIndexs", "isCustomRound", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setNativeDrawable", "round_img_lib_release"})
public abstract class AbsRoundCirclePolicy
implements IRoundCirclePolicy {
    private boolean isCircleType;
    private float mRoundRadius;
    private float mTopLeft;
    private float mTopRight;
    private float mBottomLeft;
    private float mBottomRight;
    @Nullable
    private Drawable mRoundBackgroundDrawable;
    @Nullable
    private Bitmap mRoundBackgroundBitmap;
    private boolean isBGCenterCrop;
    private int mShadowSize;
    private int mShadowColor;
    private int mShadowOffsetX;
    private int mShadowOffsetY;
    @NotNull
    private final View mContainer;

    public AbsRoundCirclePolicy(@NotNull View view, @NotNull Context context, @Nullable AttributeSet attributeSet, @NotNull int[] attrs, @NotNull int[] attrIndex) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)attrIndex, (String)"attrIndex");
        this.isBGCenterCrop = true;
        this.mContainer = view;
        this.initialize(context, attributeSet, attrs, attrIndex);
    }

    public final boolean isCircleType() {
        return this.isCircleType;
    }

    public final void setCircleType(boolean bl) {
        this.isCircleType = bl;
    }

    public final float getMRoundRadius() {
        return this.mRoundRadius;
    }

    public final void setMRoundRadius(float f) {
        this.mRoundRadius = f;
    }

    public final float getMTopLeft() {
        return this.mTopLeft;
    }

    public final void setMTopLeft(float f) {
        this.mTopLeft = f;
    }

    public final float getMTopRight() {
        return this.mTopRight;
    }

    public final void setMTopRight(float f) {
        this.mTopRight = f;
    }

    public final float getMBottomLeft() {
        return this.mBottomLeft;
    }

    public final void setMBottomLeft(float f) {
        this.mBottomLeft = f;
    }

    public final float getMBottomRight() {
        return this.mBottomRight;
    }

    public final void setMBottomRight(float f) {
        this.mBottomRight = f;
    }

    @Nullable
    public final Drawable getMRoundBackgroundDrawable() {
        return this.mRoundBackgroundDrawable;
    }

    public final void setMRoundBackgroundDrawable(@Nullable Drawable drawable) {
        this.mRoundBackgroundDrawable = drawable;
    }

    @Nullable
    public final Bitmap getMRoundBackgroundBitmap() {
        return this.mRoundBackgroundBitmap;
    }

    public final void setMRoundBackgroundBitmap(@Nullable Bitmap bitmap) {
        this.mRoundBackgroundBitmap = bitmap;
    }

    public final boolean isBGCenterCrop() {
        return this.isBGCenterCrop;
    }

    public final void setBGCenterCrop(boolean bl) {
        this.isBGCenterCrop = bl;
    }

    public final int getMShadowSize() {
        return this.mShadowSize;
    }

    public final void setMShadowSize(int n) {
        this.mShadowSize = n;
    }

    public final int getMShadowColor() {
        return this.mShadowColor;
    }

    public final void setMShadowColor(int n) {
        this.mShadowColor = n;
    }

    public final int getMShadowOffsetX() {
        return this.mShadowOffsetX;
    }

    public final void setMShadowOffsetX(int n) {
        this.mShadowOffsetX = n;
    }

    public final int getMShadowOffsetY() {
        return this.mShadowOffsetY;
    }

    public final void setMShadowOffsetY(int n) {
        this.mShadowOffsetY = n;
    }

    @NotNull
    public final View getMContainer() {
        return this.mContainer;
    }

    private final void initialize(Context context, AttributeSet attributeSet, int[] attrs, int[] attrIndexs) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, attrs);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026utes(attributeSet, attrs)");
        TypedArray typedArray2 = typedArray;
        this.isCircleType = typedArray2.getBoolean(attrIndexs[0], false);
        this.mRoundRadius = typedArray2.getDimensionPixelOffset(attrIndexs[1], 0);
        this.mTopLeft = typedArray2.getDimensionPixelOffset(attrIndexs[2], 0);
        this.mTopRight = typedArray2.getDimensionPixelOffset(attrIndexs[3], 0);
        this.mBottomLeft = typedArray2.getDimensionPixelOffset(attrIndexs[4], 0);
        this.mBottomRight = typedArray2.getDimensionPixelOffset(attrIndexs[5], 0);
        int roundBackgroundColor = typedArray2.getColor(attrIndexs[6], 0);
        this.mRoundBackgroundDrawable = (Drawable)new ColorDrawable(roundBackgroundColor);
        this.mRoundBackgroundBitmap = this.getBitmapFromDrawable(this.mRoundBackgroundDrawable);
        if (typedArray2.hasValue(attrIndexs[7])) {
            this.mRoundBackgroundDrawable = typedArray2.getDrawable(attrIndexs[7]);
            this.mRoundBackgroundBitmap = this.getBitmapFromDrawable(this.mRoundBackgroundDrawable);
        }
        this.isBGCenterCrop = typedArray2.getBoolean(attrIndexs[8], true);
        this.mShadowSize = typedArray2.getDimensionPixelSize(attrIndexs[9], 0);
        this.mShadowColor = typedArray2.getColor(attrIndexs[10], 0x10000000);
        this.mShadowOffsetX = typedArray2.getDimensionPixelSize(attrIndexs[11], 0);
        this.mShadowOffsetY = typedArray2.getDimensionPixelSize(attrIndexs[12], 0);
        typedArray2.recycle();
    }

    @Override
    public boolean onDraw(@Nullable Canvas canvas) {
        return true;
    }

    @Override
    public void setNativeDrawable(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this.mRoundBackgroundDrawable = drawable;
        this.mRoundBackgroundBitmap = this.getBitmapFromDrawable(this.mRoundBackgroundDrawable);
    }

    @Override
    public boolean isCustomRound() {
        return this.mTopLeft > 0.0f || this.mTopRight > 0.0f || this.mBottomLeft > 0.0f || this.mBottomRight > 0.0f;
    }

    @NotNull
    protected final RectF calculateBounds() {
        return new RectF(0.0f, 0.0f, (float)this.mContainer.getWidth(), (float)this.mContainer.getHeight());
    }

    @Nullable
    protected final Bitmap getBitmapFromDrawable(@Nullable Drawable drawable) {
        Bitmap bitmap;
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)drawable).getBitmap();
        } else {
            Bitmap bitmap2;
            try {
                Bitmap bitmap3;
                Bitmap bitmap4;
                if (drawable instanceof ColorDrawable) {
                    bitmap4 = Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"{\n                    Bi\u2026B_8888)\n                }");
                    bitmap3 = bitmap4;
                } else {
                    bitmap4 = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"{\n                    Bi\u2026B_8888)\n                }");
                    bitmap3 = bitmap4;
                }
                Bitmap bitmap5 = bitmap3;
                Canvas canvas = new Canvas(bitmap5);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
            }
            catch (Exception e) {
                e.printStackTrace();
                bitmap2 = null;
            }
            bitmap = bitmap2;
        }
        return bitmap;
    }

    protected final int dp2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)(dpValue * context.getResources().getDisplayMetrics().density + 0.5f);
    }
}

