/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.OTA;

import com.dk.uartnfc.OTA.CRC;
import com.dk.uartnfc.OTA.Constants;
import com.dk.uartnfc.OTA.TimeoutException;
import com.dk.uartnfc.OTA.Timer;
import com.dk.uartnfc.OTA.eventbus.PostEventBus;
import com.dk.uartnfc.UartManager.SerialManager;
import java.io.DataInputStream;
import java.io.IOException;

class Modem {
    private SerialManager mUartManager;
    protected static final byte SOH = 1;
    protected static final byte STX = 2;
    protected static final byte EOT = 4;
    protected static final byte ACK = 6;
    protected static final byte NAK = 21;
    protected static final byte CAN = 24;
    protected static final byte CPMEOF = 26;
    protected static final byte ST_C = 67;
    protected static final int MAXERRORS = 10;
    protected static final int BLOCK_TIMEOUT = 1000;
    protected static final int REQUEST_TIMEOUT = 3000;
    protected static final int WAIT_FOR_RECEIVER_TIMEOUT = 60000;
    protected static final int SEND_BLOCK_TIMEOUT = 10000;

    protected Modem(SerialManager manager) {
        this.mUartManager = manager;
    }

    protected boolean waitReceiverRequest(Timer timer) throws IOException {
        PostEventBus.post("Connecting ...");
        try {
            byte character;
            do {
                if ((character = this.readByte(timer)) != 21) continue;
                return false;
            } while (character != 67);
            return true;
        }
        catch (TimeoutException e) {
            PostEventBus.post("TimeOut,Please try again!!");
            throw new IOException("Timeout waiting for receiver");
        }
    }

    protected void sendDataBlocks(DataInputStream dataStream, int blockNumber, CRC crc, byte[] block) throws IOException {
        int dataLength;
        PostEventBus.post("write file start ...");
        while ((dataLength = dataStream.read(block)) != -1) {
            PostEventBus.post("...");
            this.sendBlock(blockNumber++, block, dataLength, crc);
        }
        PostEventBus.post("\nwrite file finish ...");
    }

    protected void sendEOT() throws IOException {
        PostEventBus.post("application start! ...");
        PostEventBus.post("http://www.unistrong.com.cn");
        Timer timer = new Timer(1000L);
        for (int errorCount = 0; errorCount < 10; ++errorCount) {
            this.sendByte((byte)4);
            try {
                byte character = this.readByte(timer.start());
                if (character == 6 || character == 21) {
                    PostEventBus.post("pro_" + Constants.sCurrentPro++);
                    return;
                }
                if (character != 24) continue;
                PostEventBus.post("Transmission terminated");
                throw new IOException("Transmission terminated");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    protected void sendBlock(int blockNumber, byte[] block, int dataLength, CRC crc) throws IOException {
        Timer timer = new Timer(10000L);
        if (dataLength < block.length) {
            block[dataLength] = 26;
        }
        int errorCount = 0;
        block2: while (errorCount < 10) {
            timer.start();
            byte[] sendTmp = new byte[block.length + 3 + crc.getCRCLength()];
            sendTmp[0] = block.length == 1024 ? 2 : 1;
            sendTmp[1] = (byte)blockNumber;
            sendTmp[2] = (byte)(~blockNumber);
            System.arraycopy(block, 0, sendTmp, 3, block.length);
            byte[] crcBytes = new byte[crc.getCRCLength()];
            long crcValue = crc.calcCRC(block);
            for (int i = 0; i < crc.getCRCLength(); ++i) {
                crcBytes[crc.getCRCLength() - i - 1] = (byte)(crcValue >> 8 * i & 0xFFL);
            }
            System.arraycopy(crcBytes, 0, sendTmp, block.length + 3, crcBytes.length);
            this.write(sendTmp);
            try {
                byte character;
                do {
                    if ((character = this.readByte(timer)) == 6) {
                        PostEventBus.post("pro_" + Constants.sCurrentPro++);
                        return;
                    }
                    if (character != 21) continue;
                    ++errorCount;
                    continue block2;
                } while (character != 24);
                PostEventBus.post("Transmission terminated");
                throw new IOException("Transmission terminated");
            }
            catch (TimeoutException e) {
                ++errorCount;
            }
        }
        PostEventBus.post("Too many errors caught, abandoning transfer");
        throw new IOException("Too many errors caught, abandoning transfer");
    }

    private void writeCRC(byte[] block, CRC crc) throws IOException {
        byte[] crcBytes = new byte[crc.getCRCLength()];
        long crcValue = crc.calcCRC(block);
        for (int i = 0; i < crc.getCRCLength(); ++i) {
            crcBytes[crc.getCRCLength() - i - 1] = (byte)(crcValue >> 8 * i & 0xFFL);
        }
        this.write(crcBytes);
    }

    protected void sendByte(byte b) throws IOException {
        this.write(new byte[]{b});
    }

    private void shortSleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            try {
                this.interruptTransmission();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Transmission was interrupted", e);
        }
    }

    protected void interruptTransmission() throws IOException {
        this.sendByte((byte)24);
        this.sendByte((byte)24);
    }

    private byte readByte(Timer timer) throws IOException, TimeoutException {
        byte[] buf;
        int read;
        while ((read = this.mUartManager.read(buf = new byte[1], 1, 1100, 20)) <= 0) {
            if (timer.isExpired()) {
                throw new TimeoutException();
            }
            this.shortSleep();
        }
        return buf[0];
    }

    public void write(byte[] b) {
        this.mUartManager.send(b);
    }
}

