/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.DeviceManager;

import android.util.Log;
import com.dk.uartnfc.Card.CpuCard;
import com.dk.uartnfc.Card.DESFire;
import com.dk.uartnfc.Card.DeviceManagerCallback;
import com.dk.uartnfc.Card.FeliCa;
import com.dk.uartnfc.Card.Iso14443BIdCard;
import com.dk.uartnfc.Card.Iso14443bCard;
import com.dk.uartnfc.Card.Iso15693Card;
import com.dk.uartnfc.Card.Mifare;
import com.dk.uartnfc.Card.Ntag21x;
import com.dk.uartnfc.Card.Ultralight;
import com.dk.uartnfc.DKCloudID.IDCard;
import com.dk.uartnfc.DKCloudID.IDCardData;
import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DKCloudIDException;
import com.dk.uartnfc.Tool.StringTool;
import com.dk.uartnfc.UartManager.DKMessageDef;
import com.dk.uartnfc.UartManager.SerialManager;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class DeviceManager {
    private static final String TAG = "DeviceManager";
    public SerialManager serialManager = new SerialManager();
    public static final byte CARD_TYPE_NO_DEFINE = 0;
    public static final byte CARD_TYPE_ISO4443_A = 4;
    public static final byte CARD_TYPE_ISO4443_B = 3;
    public static final byte CARD_TYPE_FELICA = 6;
    public static final byte CARD_TYPE_MIFARE = 1;
    public static final byte CARD_TYPE_ISO15693 = 5;
    public static final byte CARD_TYPE_ULTRALIGHT = 2;
    public static final byte CARD_TYPE_DESFire = 9;
    public static final byte CARD_TYPE_SAMV_ID = -93;
    private DeviceManagerCallback mDeviceManagerCallback = null;
    private static final Semaphore semaphore = new Semaphore(1);
    public CpuCard cpuCard;
    public Iso14443bCard iso14443bCard;
    public DESFire desFire;
    public Iso15693Card iso15693Card;
    public Mifare mifare;
    public Ntag21x ntag21x;
    public Ultralight ultralight;
    public FeliCa feliCa;
    public Iso14443BIdCard iso14443BIdCard;
    public int mCardType;

    public DeviceManager() {
        this.serialManager.setOnReceiveDataListener(new SerialManager.onReceiveDataListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void OnReceiverData(String portNumberString, byte[] data) {
                try {
                    Log.d((String)DeviceManager.TAG, (String)(portNumberString + "\u63a5\u6536(" + data.length + ")\uff1a" + StringTool.byteHexToSting(data) + "\r\n"));
                    DKMessageDef dkMessageDef = Command.getRspMsg(data);
                    switch (dkMessageDef.command) {
                        case 1: {
                            DeviceManager.this.mCardType = dkMessageDef.data[0];
                            byte[] uidBytes = Arrays.copyOfRange(dkMessageDef.data, 1, dkMessageDef.data.length);
                            byte[] atrBytes = null;
                            switch (DeviceManager.this.mCardType) {
                                case 4: {
                                    DeviceManager.this.cpuCard = new CpuCard(DeviceManager.this, uidBytes, atrBytes);
                                    break;
                                }
                                case 3: {
                                    DeviceManager.this.iso14443bCard = new Iso14443bCard(DeviceManager.this, uidBytes, atrBytes);
                                    break;
                                }
                                case 6: {
                                    DeviceManager.this.feliCa = new FeliCa(DeviceManager.this, uidBytes, atrBytes);
                                    break;
                                }
                                case 1: {
                                    DeviceManager.this.mifare = new Mifare(DeviceManager.this, uidBytes, atrBytes);
                                    break;
                                }
                                case 5: {
                                    DeviceManager.this.iso15693Card = new Iso15693Card(DeviceManager.this, uidBytes, atrBytes);
                                    break;
                                }
                                case 2: {
                                    DeviceManager.this.ntag21x = new Ntag21x(DeviceManager.this, uidBytes, atrBytes);
                                    break;
                                }
                                case 9: {
                                    DeviceManager.this.desFire = new DESFire(DeviceManager.this, uidBytes, atrBytes);
                                    break;
                                }
                            }
                            if (DeviceManager.this.mDeviceManagerCallback == null) return;
                            DeviceManager.this.mDeviceManagerCallback.onReceiveRfnSearchCard(true, DeviceManager.this.mCardType, uidBytes, null);
                            return;
                        }
                        case 50: {
                            DeviceManager.this.mCardType = -93;
                            DeviceManager.this.iso14443BIdCard = new Iso14443BIdCard(DeviceManager.this);
                            DeviceManager.this.iso14443BIdCard.setInitData(dkMessageDef.data);
                            try {
                                if (!semaphore.tryAcquire(0L, TimeUnit.MILLISECONDS)) {
                                    Log.d((String)DeviceManager.TAG, (String)"\u4e0a\u6b21\u89e3\u6790\u8fd8\u672a\u5b8c\u6210\uff0c\u629b\u5f03\u672c\u6b21\u5237\u7684\u8eab\u4efd\u8bc1");
                                    return;
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                Log.d((String)DeviceManager.TAG, (String)"\u4e0a\u6b21\u89e3\u6790\u8fd8\u672a\u5b8c\u6210\uff0c\u629b\u5f03\u672c\u6b21\u5237\u7684\u8eab\u4efd\u8bc1");
                                return;
                            }
                            if (DeviceManager.this.mDeviceManagerCallback != null) {
                                DeviceManager.this.mDeviceManagerCallback.onReceiveSamVIdStart(dkMessageDef.data);
                            }
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    block5: {
                                        try {
                                            IDCardData idCardData = DeviceManager.this.startDkcloudid(DeviceManager.this.iso14443BIdCard);
                                            if (idCardData != null && DeviceManager.this.mDeviceManagerCallback != null) {
                                                if (idCardData.PhotoBmp == null) {
                                                    DeviceManager.this.mDeviceManagerCallback.onReceiveSamVIdException("\u660e\u6587\u6570\u636e\u5f02\u5e38");
                                                } else {
                                                    DeviceManager.this.mDeviceManagerCallback.onReceiveIDCardData(idCardData);
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            if (DeviceManager.this.mDeviceManagerCallback == null) break block5;
                                            DeviceManager.this.mDeviceManagerCallback.onReceiveSamVIdException(e.getMessage());
                                        }
                                    }
                                    semaphore.release();
                                }
                            }).start();
                            return;
                        }
                        case -2: {
                            if (DeviceManager.this.mDeviceManagerCallback == null) return;
                            DeviceManager.this.mDeviceManagerCallback.onReceiveACK();
                            return;
                        }
                        case -1: {
                            if (DeviceManager.this.mDeviceManagerCallback == null) return;
                            DeviceManager.this.mDeviceManagerCallback.onReceiveNACK();
                            return;
                        }
                        case -22: {
                            if (DeviceManager.this.mDeviceManagerCallback == null) return;
                            DeviceManager.this.mDeviceManagerCallback.onReceiveCardLeave();
                            return;
                        }
                    }
                    return;
                }
                catch (CardNoResponseException e) {
                    e.printStackTrace();
                    Log.e((String)DeviceManager.TAG, (String)e.getMessage());
                }
            }
        });
    }

    public Object getCard() {
        switch (this.mCardType) {
            case 4: {
                return this.cpuCard;
            }
            case 3: {
                return this.iso14443bCard;
            }
            case 6: {
                return this.feliCa;
            }
            case 1: {
                return this.mifare;
            }
            case 5: {
                return this.iso15693Card;
            }
            case 2: {
                return this.ntag21x;
            }
            case 9: {
                return this.desFire;
            }
            case -93: {
                return this.iso14443BIdCard;
            }
        }
        return null;
    }

    public void setCallBack(DeviceManagerCallback callBack) {
        this.mDeviceManagerCallback = callBack;
    }

    private synchronized IDCardData startDkcloudid(Iso14443BIdCard card) {
        block6: {
            if (card == null) {
                Log.e((String)TAG, (String)"\u672a\u627e\u5230\u8eab\u4efd\u8bc1");
                if (this.mDeviceManagerCallback != null) {
                    this.mDeviceManagerCallback.onReceiveSamVIdException("\u672a\u627e\u5230\u8eab\u4efd\u8bc1");
                }
                return null;
            }
            try {
                return IDCard.getInstance().getIDCardData(card, 5, new IDCard.onReceiveScheduleListener(){

                    @Override
                    public void onReceiveSchedule(int rate) {
                        if (DeviceManager.this.mDeviceManagerCallback != null) {
                            DeviceManager.this.mDeviceManagerCallback.onReceiveSamVIdSchedule(rate);
                        }
                    }
                });
            }
            catch (DKCloudIDException e) {
                if (this.mDeviceManagerCallback != null) {
                    this.mDeviceManagerCallback.onReceiveSamVIdException(e.getMessage());
                }
            }
            catch (CardNoResponseException e) {
                if (this.mDeviceManagerCallback == null) break block6;
                this.mDeviceManagerCallback.onReceiveSamVIdException(e.getMessage());
            }
        }
        return null;
    }

    public void release() {
        semaphore.release();
    }
}

