package com.gitee.aachen0.util;

import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
import java.awt.*;
import java.io.File;
import java.io.FileNotFoundException;

/**
 * Swings GUI编程工具类
 */
public class Swings {
    /**
     * 以图形化的界面获取一个文件对象
     *
     * @return 用户选择的那个文件对象
     */
    public static File openFile(String descrition, String... extensionName) {
        JFrame jFrame = new JFrame();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter(descrition, extensionName));
        int index = chooser.showOpenDialog(jFrame);

        if (index == JFileChooser.APPROVE_OPTION) {
            try {
                jFrame.dispose();// 关闭隐藏的主窗体
            } catch (Exception e) {
                e.printStackTrace();
            }
            return chooser.getSelectedFile();
        } else {
            try {
                throw new FileNotFoundException();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /**
     * 将一个JFrame控件的位置在屏幕水平垂直居中
     * @param component 需要居中的组件
     */
    public static void alignCenter(Component component) {
        int width = component.getWidth();
        int height = component.getHeight();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setLocation((int) (dimension.getWidth() - width) / 2, (int) (dimension.getHeight() - height) / 2);
    }

    /**
     * 批量设置组件大小
     * @param width 设置组件的宽
     * @param height 设置组件的高
     * @param components 批量设置的组件
     */
    public static void batResize(int width, int height, Component... components) {
        for (Component b : components) {
            b.setSize(width, height);
        }
    }

    /**
     * 批量将组件添加到窗体容器
     * @param container 窗体容器
     * @param components 组件
     */
    public static void batAdd(Window container, Component... components) {
        for (Component c : components) {
            container.add(c);
        }
    }

}
