package com.gitee.aachen0.util;

import java.io.UnsupportedEncodingException;

/**
 * 字符串操作工具类
 */
public class Strings {
    /**
     * 向一个字符串的指定位置插入一个字符
     *
     * @param string 待插入的字符串
     * @param index  插入字符的下标，将在这个下标之前插入字符
     * @param ch     插入的字符
     * @return 插入字符后的字符串
     */
    public static String insert(CharSequence string, int index, char ch) {
        return new StringBuffer(string).insert(index, ch).toString();
    }

    /**
     * 向一个字符串的指定位置插入一个字符串
     *
     * @param string 待插入的字符串
     * @param index  插入字符的下标，将在这个下标之前插入字符串
     * @param subStr 插入的字符串
     * @return 插入字符串后的字符串
     */
    public static String insert(CharSequence string, int index, CharSequence subStr) {
        return new StringBuffer(string).insert(index, subStr).toString();
    }

    /**
     * 确保下标不越界
     *
     * @param string 待插入的字符串
     * @param index  插入字符的下标(可能存在非法值)
     * @return 安全的下标值
     */
    private static int safeIndex(CharSequence string, int index) {
        int length = string.length();
        index = (index < 0) ? 0 : index;
        index = (index > length) ? length : index;
        return index;
    }

    /**
     * 获取指定个数重复字符的字符串
     *
     * @param ch   字符
     * @param many 个数
     * @return 重复字符的字符串
     */
    public static String multipleChar(char ch, int many) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < many; i++) {
            sb.append(ch);
        }
        return sb.toString();
    }

    /**
     * 查找指定字符在字符串中出现的次数
     *
     * @param string 查找的字符串
     * @param ch     指定的字符
     * @return 字符出现的次数
     */
    public static int numberOfChar(CharSequence string, char ch) {
        int number = 0;
        for (int i = 0; i < string.length(); i++) {
            if (ch == string.charAt(i)) number++;
        }
        return number;
    }

    /**
     * 从一个文件路径获取文件的扩展名
     *
     * @param filePath 文件路径
     * @return 扩展名
     */
    public static String getExtension(String filePath) {
        if (filePath == null || filePath.indexOf('.') <= 0) return null;
        return filePath.substring(filePath.lastIndexOf('.') + 1);
    }

    /**
     * 转码神器，将字符串从一个编码方式改为目标编码
     *
     * @param context     待转字符串
     * @param oriCharset  字符串实际使用的编码方式
     * @param destCharset 字符串显示环境的编码
     * @return 转换为显示环境一致的编码后的字符串
     */
    public static String transEncode(String context, String oriCharset, String destCharset) {
        if (context == null) return null;
        try {
            return new String(context.getBytes(oriCharset), destCharset);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }
}
