package com.gitee.aachen0.util;

import lombok.Data;

import java.text.SimpleDateFormat;

/**
 * 手机功能模拟，用于开发中的短信收发测试
 */
@Data
public class Phone {
    private String model;// 手机型号
    private String ownerName;// 机主姓名
    private String ownerNumber;// 机主号码
    private int width = 10;// 显示屏一行多少汉字,默认10（一个汉字占两个英文字符宽）
    private int indent = 2;// 短信显示左缩进

    /**
     * 在控制台显示收到的信息
     *
     * @param msg        收到的短信息内容
     * @param fromNumber 短信发送者的号码
     */
    public void showMessage(String msg, String fromNumber) {

        // 短信内容
        System.out.println("本机号码：" + ownerNumber);
        System.out.println("来信号码：" + fromNumber);
        System.out.println("收信时间：" + new SimpleDateFormat("M-dd hh:mm").format(System.currentTimeMillis()));
        System.out.println(Strings.multipleChar('-', width) + "短信开始" + Strings.multipleChar('-', width));
        System.out.println(formatMsg(msg));
        System.out.println(Strings.multipleChar('-', width) + "短信结束" + Strings.multipleChar('-', width));
    }

    // 将一段字符串短信的形式格式化
    private String formatMsg(String msg) {
        int linedigits = 0;// 每行字符个数，用来控制换行
        String indentStr = Strings.multipleChar(' ', indent);// 短信左缩进,调用了Strings工具类的multipleChar方法
        StringBuilder formMsg = new StringBuilder("\r\n").append(indentStr);// 先换行缩进
        for (int i = 0; i < msg.length(); i++) {
            char temp = msg.charAt(i);
            formMsg.append(temp);
            if (temp < 128) {// 键盘字符一个字符占一个位置
                linedigits++;
            } else {// 其他字符一个字符占两个位置
                linedigits += 2;
            }
            if (linedigits >= width * 2 - 1) {
                linedigits = 0;
                formMsg.append("\r\n").append(indentStr);
            }
        }
        formMsg.append("\r\n");
        return formMsg.toString();
    }
}
