package com.gitee.aachen0.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * Math工具类的补充，提供了一些Math类没有的功能
 */
public class Maths {
    /**
     * 将一个表示字节个数的整数自适应单位格式化输出,保留两位小数
     *
     * @param bytes 整数
     * @return 格式化后的字符串
     */
    public static String formatBytes(Long bytes) {
        String sizeString;
        float tmp = bytes;// 强转为float以免丢失数据
        DecimalFormat df = new DecimalFormat("#.00");// 保留两位小数
        if (bytes < 0) {
            sizeString = "Error";
        } else if (bytes < 1024) {
            sizeString = tmp + "B";
        } else if (bytes < 1024 * 1024) {
            sizeString = df.format(tmp / 1024) + "K";
        } else if (bytes < 1024 * 1024 * 1024) {
            sizeString = df.format(tmp / 1024 / 1024) + "M";
        } else if (bytes < 1024L * 1024 * 1024 * 1024) {
            sizeString = df.format(tmp / 1024L / 1024 / 1024) + "G";
        } else {
            sizeString = df.format(tmp / 1024L / 1024 / 1024 / 1024) + "T";
        }
        return sizeString;
    }

    /**
     * 四舍五入一个浮点数到指定小数位
     *
     * @param d      待处理的浮点数
     * @param digits 保留小数位
     * @return 指定小数位的浮点数
     */
    public static double fixDigits(double d, int digits) {
        BigDecimal bd = new BigDecimal(d);
        return bd.setScale(digits, BigDecimal.ROUND_HALF_UP).doubleValue();
    }
}
