package com.gitee.aachen0.util;

import java.util.Scanner;

/**
 * time created:2018/6/26 14:01<br>
 * 这是一个自写的工具，简化了初学java者从键盘接收输入的过程;<br>
 * 使用说明:<br>
 * 将Tool.class文件放置在项目工作目录下，在自己的代码中可以直接通过类名调用该工具类中的方法，比如：<br>
 * int x = Inputs.inputInt("请输入整数x:");<br>
 * 可以从键盘接收一个int类型的整数,而后赋值给变量x；
 *
 * @author aachen0
 * @version 1.01
 * <br>改为异常抛出，不再判断是否读取成功
 */
public class Inputs {

    private static Scanner get = new Scanner(System.in);

    /**
     * 从键盘接收一组整数，以数组的形式返回
     *
     * @param tip 输入提示信息
     * @return 存有输入整数的int数组
     */
    public static int[] inputInts(String tip) {
        if (tip != null && !"".equals(tip)) System.out.println(tip);// 如果不想要提示可以提供一个空字符串或是一个null
        String s = get.nextLine();
        s = s.trim();// 去掉首尾空字符，避免切出空字符
        String[] ss = s.split("\\s+");
        int[] ints = new int[ss.length];
        for (int i = 0; i < ints.length; i++) {
            ints[i] = Integer.parseInt(ss[i]);
        }
        return ints;
    }

    /**
     * 从键盘输入读取一个int类型数据
     *
     * @param tip 提示用户从键盘输入的数据信息,如果不想要提示可以提供一个空字符串或是一个null
     * @return 从键盘输入读取的int类型数据
     */
    public static int inputInt(String tip) {
        if (tip != null && !"".equals(tip)) System.out.println(tip);// 如果不想要提示可以提供一个空字符串或是一个null
        int result = get.nextInt();
        get.nextLine();
        return result;
    }

    /**
     * 从键盘输入的一串数据中读取开头的一个char
     *
     * @param tip 提示用户从键盘输入的数据信息
     * @return 从键盘输入读取的char类型数据
     */
    public static char inputChar(String tip) {
        return input(tip).charAt(0);
    }

    /**
     * 从键盘输入读取一个double类型数据，读取失败返回值为-1.0
     *
     * @param tip 提示用户从键盘输入的数据信息
     * @return 从键盘输入读取的double类型数据
     */
    public static double inputDouble(String tip) {
        if (tip != null && !"".equals(tip))
            System.out.println(tip);
        double result = get.nextDouble();
        get.nextLine();
        return result;
    }

    /**
     * 从键盘接收一组小数，以double数组的形式返回
     *
     * @param tip 输入提示信息
     * @return 存有输入小数的double数组
     */
    public static double[] inputDoubles(String tip) {
        if (tip != null && !"".equals(tip)) System.out.println(tip);// 如果不想要提示可以提供一个空字符串或是一个null
        String s = get.nextLine();
        s = s.trim();// 去掉首尾的空格，避免割除空串
        String[] ss = s.split("\\s+");
        double[] doubles = new double[ss.length];
        for (int i = 0; i < doubles.length; i++) {
            doubles[i] = Double.parseDouble(ss[i]);
        }
        return doubles;
    }

    /**
     * 从键盘输入读取一个String类型数据
     *
     * @param tip 提示用户从键盘输入的数据信息
     * @return 从键盘输入读取的String类型数据
     */
    public static String input(String tip) {
        if (tip != null && !"".equals(tip))
            System.out.println(tip);
        String result = get.next();
        get.nextLine();
        return result;
    }

    /**
     * 从键盘输入读取一个long类型数据
     *
     * @param tip 提示用户从键盘输入的数据信息
     * @return 从键盘输入读取的long类型数据
     */
    public static long inputLong(String tip) {
        if (tip != null && !"".equals(tip))
            System.out.println(tip);
        long result = get.nextLong();
        get.nextLine();
        return result;
    }

    /**
     * 从键盘读取一整行
     *
     * @param tip 输入提示语
     * @return 读取的一行字符串
     */
    public static String inputLine(String tip) {
        System.out.println(tip);
        String string = get.nextLine();
        if ("".equals(string)) return inputLine("未接收到有效行，请重新输入！");
        return string;
    }

}