/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.aachen0.util;

import com.gitee.aachen0.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Property {
    public static Map<String, String> getMap(String propPath) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties = new Properties();
        String extension = Strings.getExtension(propPath);
        if ("properties".equals(extension)) {
            properties.load(new FileReader(propPath));
        } else if ("xml".equals(extension)) {
            properties.loadFromXML(new FileInputStream(propPath));
        } else {
            throw new IllegalArgumentException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e\uff01");
        }
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    public static boolean mapToProp(Map<String, String> map, String propPath, String comments) throws IOException {
        boolean result = false;
        Properties properties = new Properties();
        Set<String> keys = map.keySet();
        if (keys.size() <= 0) {
            return false;
        }
        File prop = new File(propPath);
        if (!prop.exists()) {
            result = prop.createNewFile();
        }
        for (String key : keys) {
            properties.setProperty(key, map.get(key));
        }
        String extension = Strings.getExtension(propPath);
        if ("properties".equals(extension)) {
            properties.store(new FileWriter(prop), comments);
        } else if ("xml".equals(extension)) {
            properties.storeToXML(new FileOutputStream(propPath), comments);
        }
        return result;
    }

    public static boolean mapUpdateToProp(Map<String, String> map, String propPath, String comments) throws IOException {
        if (map == null || map.size() <= 0) {
            return false;
        }
        Map<String, String> originMap = Property.getMap(propPath);
        originMap.putAll(map);
        return Property.mapToProp(originMap, propPath, comments);
    }
}

