/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.aachen0.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;

public class JDBCUtil {
    public static Connection getConnection(String jdbc) {
        InputStream is = JDBCUtil.class.getResourceAsStream(jdbc);
        Properties pro = new Properties();
        Connection connection = null;
        try {
            pro.load(is);
            Class.forName(pro.getProperty("driverName"));
            connection = DriverManager.getConnection(pro.getProperty("url"), pro.getProperty("user"), pro.getProperty("password"));
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return connection;
    }

    public static <T> Object rsToObject(ResultSet rs, Class<T> clazz) {
        Object object = null;
        try {
            object = clazz.newInstance();
            ResultSetMetaData data = rs.getMetaData();
            int n = data.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String columnName = data.getColumnName(i);
                String columnType = data.getColumnTypeName(i);
                Object o = rs.getObject(columnName);
                String setter = "set" + columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
                Class paraType = JDBCUtil.jdbcToJavaType(columnType);
                Method method = clazz.getMethod(setter, paraType);
                Class packType = JDBCUtil.toPackType(paraType);
                method.invoke(object, packType.cast(o));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            e.printStackTrace();
        }
        return object;
    }

    private static Class toPackType(Class paraType) {
        switch (paraType.getName()) {
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "short": {
                return Short.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
        }
        return paraType;
    }

    private static Class jdbcToJavaType(String columnType) {
        switch (columnType) {
            case "TINYINT": 
            case "TINYINT UNSIGNED": 
            case "SMALLINT": 
            case "SMALLINT UNSIGNED": 
            case "MEDIUMINT": 
            case "MEDIUMINT UNSIGNED": 
            case "INT": {
                return Integer.TYPE;
            }
            case "BIGINT": 
            case "INT UNSIGNED": {
                return Long.TYPE;
            }
            case "BIGINT UNSIGNED": {
                return BigInteger.class;
            }
            case "FLOAT": 
            case "FLOAT UNSIGNED": {
                return Float.TYPE;
            }
            case "DOUBLE": 
            case "DOUBLE UNSIGNED": {
                return Double.TYPE;
            }
            case "CHAR": 
            case "VARCHAR": {
                return String.class;
            }
            case "DECIMAL": 
            case "DECIMAL UNSIGNED": {
                return BigDecimal.class;
            }
            case "TIME": {
                return Time.class;
            }
            case "YEAR": 
            case "DATE": {
                return Date.class;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                return Timestamp.class;
            }
        }
        return String.class;
    }
}

