/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.aachen0.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class EncodeCheck {
    public static String CODE_UTF8 = "UTF-8";
    public static String CODE_UTF8_BOM = "UTF-8_BOM";
    public static String CODE_GBK = "GBK";
    private static int BYTE_SIZE = 8;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getEncode(String fullFileName, boolean ignoreBom) {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fullFileName));){
            String string = EncodeCheck.getEncode(bis, ignoreBom);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncode(BufferedInputStream bis, boolean ignoreBom) {
        bis.mark(0);
        String encodeType = "";
        byte[] head = new byte[3];
        try {
            bis.read(head);
            encodeType = head[0] == -1 && head[1] == -2 ? "UTF-16" : (head[0] == -2 && head[1] == -1 ? "Unicode" : (head[0] == -17 && head[1] == -69 && head[2] == -65 ? (ignoreBom ? CODE_UTF8 : CODE_UTF8_BOM) : (EncodeCheck.isUTF8(bis) ? CODE_UTF8 : CODE_GBK)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return encodeType;
    }

    private static boolean isUTF8(BufferedInputStream bis) throws IOException {
        bis.reset();
        int code = bis.read();
        do {
            BitSet bitSet;
            if (!(bitSet = EncodeCheck.convert2BitSet(code)).get(0) || EncodeCheck.checkMultiByte(bis, bitSet)) continue;
            return false;
        } while ((code = bis.read()) != -1);
        return true;
    }

    private static boolean checkMultiByte(BufferedInputStream bis, BitSet bitSet) throws IOException {
        int count = EncodeCheck.getCountOfSequential(bitSet);
        byte[] bytes = new byte[count - 1];
        bis.read(bytes);
        for (byte b : bytes) {
            if (EncodeCheck.checkUtf8Byte(b)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkUtf8Byte(byte b) {
        BitSet bitSet = EncodeCheck.convert2BitSet(b);
        return bitSet.get(0) && !bitSet.get(1);
    }

    private static int getCountOfSequential(BitSet bitSet) {
        int count = 0;
        for (int i = 0; i < BYTE_SIZE && bitSet.get(i); ++i) {
            ++count;
        }
        return count;
    }

    private static BitSet convert2BitSet(int code) {
        BitSet bitSet = new BitSet(BYTE_SIZE);
        for (int i = 0; i < BYTE_SIZE; ++i) {
            int tmp3 = code >> BYTE_SIZE - i - 1;
            int tmp2 = 1 & tmp3;
            if (tmp2 != 1) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public static void convert(String oldFullFileName, String oldCharsetName, String newFullFileName, String newCharsetName) throws Exception {
        String line;
        StringBuffer content = new StringBuffer();
        BufferedReader bin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(oldFullFileName), oldCharsetName));
        while ((line = bin.readLine()) != null) {
            content.append(line);
            content.append(System.getProperty("line.separator"));
        }
        File dir = new File((newFullFileName = newFullFileName.replace("\\", "/")).substring(0, newFullFileName.lastIndexOf("/")));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(newFullFileName), newCharsetName);
        out.write(content.toString());
    }
}

