package com.gitee.aachen0.util;

/**
 * 字符串操作工具类
 * createDate 2018/10/10<br>
 * <a href="https://gitee.com/aachen0/autil">gitee source</a><br>
 *
 * @author aachen0
 * @version 1.0
 * @since 1.0
 */
public class Strings {
    
    /**
     * 获取指定个数重复字符的字符串
     *
     * @param ch   字符
     * @param many 个数
     * @return 重复字符的字符串
     */
    public static String multipleChar(char ch, int many) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < many; i++) {
            sb.append(ch);
        }
        return sb.toString();
    }
    
    /**
     * 查找指定字符在字符串中出现的次数
     *
     * @param string 查找的字符串
     * @param ch     指定的字符
     * @return 字符出现的次数
     */
    public static int numberOfChar(CharSequence string, char ch) {
        int number = 0;
        if (string != null) {
            for (int i = 0; i < string.length(); i++) {
                if (ch == string.charAt(i)) number++;
            }
        }
        return number;
    }
    
    /**
     * 从一个文件路径获取文件的扩展名
     *
     * @param filePath 文件路径
     * @return 扩展名
     */
    public static String getExtension(String filePath) {
        if (filePath == null || filePath.indexOf('.') <= 0) return null;
        return filePath.substring(filePath.lastIndexOf('.') + 1);
    }
}
