package com.gitee.aachen0.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * Math工具类的补充，提供了一些Math类没有的功能
 * createDate 2018/10/10<br>
 * <a href="https://gitee.com/aachen0/autil">gitee source</a><br>
 *
 * @author aachen0
 * @version 1.0
 * @since 1.0
 */
public class Maths {
    /**
     * 将一个表示字节个数的整数自适应单位格式化输出,保留两位小数
     *
     * @param bytes 整数
     * @return 格式化后的字符串
     */
    public static String formatBytes(Long bytes) {
        String sizeString;
        float tmp = bytes;// 强转为float以免丢失数据
        DecimalFormat df = new DecimalFormat("#.##");// 保留两位小数,不补零，如果需要补零，使用"#.00"
        if (bytes < 0) {
            sizeString = "Wrong number!";
        } else if (bytes < 1024) {
            sizeString = df.format(tmp) + "B";// byte
        } else if (bytes < 1024 * 1024) {
            sizeString = df.format(tmp / 1024) + "K";// KB
        } else if (bytes < 1024 * 1024 * 1024) {
            sizeString = df.format(tmp / 1024 / 1024) + "M";// MB
        } else if (bytes < 1024L * 1024 * 1024 * 1024) {
            sizeString = df.format(tmp / 1024L / 1024 / 1024) + "G";// GB
        } else if (bytes < 1024L * 1024 * 1024 * 1024 * 1024) {
            sizeString = df.format(tmp / 1024L / 1024 / 1024 / 1024) + "T";// TB
        } else if (bytes < 1024L * 1024 * 1024 * 1024 * 1024 * 1024) {
            sizeString = df.format(tmp / 1024L / 1024 / 1024 / 1024 / 1024) + "P";// PB
        } else {
            sizeString = df.format(tmp / 1024L / 1024 / 1024 / 1024 / 1024 / 1024) + "E";// EB
        }
        return sizeString;
    }
}
