package com.tm.datamanager.webservicesmanager.requests;

import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import com.tm.datamanager.webservicesmanager.WebServicesManager;
import com.tm.datamanager.webservicesmanager.error.CancelError;

import org.json.JSONException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Created by Navas on 23/06/15
 * This is the parent of the request
 * By default return the response in String format
 */
public class  CustomRequest<T> extends JsonRequest<T> {

    private static Map<String, String> headers;
    private Map<String, String> params;
    private Response.Listener listener;
    private String path;
    private String requestBody;
    private Response.ErrorListener errorListener;
    private Priority priority;

    private static final String REQUEST_EXCEPTION = "REQUEST_EXCEPTION";
    private static final String RESPONSE = "response";

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, WebServicesManager.configuration.getEnvironment()+path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, WebServicesManager.configuration.getEnvironment()+path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, environment+path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, environment+path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    @Override
    protected void deliverResponse(T response) {
        listener.onResponse(response);
    }

    @Override
    protected VolleyError parseNetworkError(VolleyError volleyError) {
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS())
            Log.e("DATAMANAGER", "REQUEST: " + path + requestBody);
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
            writeLogInFile("REQUEST: " + path + requestBody);
        volleyError.printStackTrace();
        String error="";
        VolleyError parseError = null;
        if(volleyError.getMessage() != null){
            error = volleyError.getMessage();
        }else if(volleyError.networkResponse != null && volleyError.networkResponse.data != null){
            error = new String(volleyError.networkResponse.data);
            parseError = WebServicesManager.configuration.checkError(error);
        }else if(volleyError.networkResponse != null){
            error = volleyError.networkResponse.statusCode+"";
        }
        Log.e("DATAMANAGER", "ERROR: " + error);
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
            writeLogInFile("ERROR:  " + error);
        if(parseError != null) return parseError;
        return new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE());
    }

    @Override
    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        if(WebServicesManager.configuration.isSAVECOOKIES()) {
            WebServicesManager.headers = response.headers;
            WebServicesManager.headers.remove("Content-Length");
        }
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS())
            Log.e("DATAMANAGER", "REQUEST: " + path + requestBody);
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
            writeLogInFile("REQUEST: " + path + requestBody);

        try {

            String responseData = new String(response.data, HttpHeaderParser.parseCharset(response.headers));

            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS())
                Log.e("DATAMANAGER", "RESPONSE: " + path + " " + responseData);
            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
                writeLogInFile("RESPONSE: " + path + " " + responseData);

            VolleyError volleyError = WebServicesManager.configuration.checkError(responseData);
            if (volleyError != null) {
                return Response.error(volleyError);
            } else {
                return Response.success((T) parseResponse(responseData)
                        , HttpHeaderParser.parseCacheHeaders(response));
            }

        } catch (Exception e) {
            e.printStackTrace();
            return Response.error(new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE()));
        }
    }

    protected Object parseResponse(String response) throws JSONException {
        return response;
    }

    /**
     * WRITE THE REQUESTS AND RESPONSES IN THE LOG FILE
     *
     * @param text log to write in the log
     */
    public static void writeLogInFile(String text) {
        File root = android.os.Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + WebServicesManager.configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, true);
            pw.append(text + "\n");
            pw.flush();
            pw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    // GETTERS AND SETTERS

    @Override
    public Priority getPriority() {
        if (priority == null)
            return super.getPriority();
        return priority;
    }

//    @Override
//    public Map<String, String> getHeaders() {
//        if (WebServicesManager.headers != null) {
//            return WebServicesManager.headers;
//        } else {
//            try {
//                return super.getHeaders();
//            } catch (AuthFailureError e) {
//                Log.e(REQUEST_EXCEPTION, "Error en las cabeceras");
//            }
//        }
//
//        return null;
//    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public Map<String, String> getParams() {
        if (params != null) {
            return params;
        } else {
            try {
                return super.getParams();
            } catch (AuthFailureError e) {
                Log.e(REQUEST_EXCEPTION, "Error en las cabeceras");
            }
        }

        return null;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }


    public Response.Listener getListener() {
        return listener;
    }

    public void setListener(Response.Listener listener) {
        this.listener = listener;
    }

    public String getPath() {
        return path;
    }

    @Override
    public String getUrl() {
        if(getMethod() == Method.POST)
            return super.getUrl();
        else
            return super.getUrl()+requestBody;
    }

    @Override
    public void cancel() {
        super.cancel();
        errorListener.onErrorResponse(new CancelError());
    }
}